"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIndexPatterns = void 0;
var _react = require("react");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
var _source = require("../../../common/containers/source");
var i18n = _interopRequireWildcard(require("../../../common/containers/source/translations"));
var _use_rule_indices = require("../../rule_management/logic/use_rule_indices");
var _helpers = require("../../../detections/pages/detection_engine/rules/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for fetching the fields to be used for populating the exception
 * item conditions options.
 *
 */
const useFetchIndexPatterns = rules => {
  const {
    data,
    spaces
  } = (0, _kibana.useKibana)().services;
  const {
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const [dataViewLoading, setDataViewLoading] = (0, _react.useState)(false);
  const [activeSpaceId, setActiveSpaceId] = (0, _react.useState)('');
  const isSingleRule = (0, _react.useMemo)(() => rules != null && rules.length === 1, [rules]);
  const isMLRule = (0, _react.useMemo)(() => rules != null && isSingleRule && rules[0].type === 'machine_learning', [isSingleRule, rules]);
  (0, _react.useEffect)(() => {
    const fetchAndSetActiveSpace = async () => {
      if (spaces) {
        const aSpace = await spaces.getActiveSpace();
        setActiveSpaceId(aSpace.id);
      }
    };
    fetchAndSetActiveSpace();
  }, [spaces]);
  // If data view is defined, it superceeds use of rule defined index patterns.
  // If no rule is available, use fields from default data view id.
  const memoDataViewId = (0, _react.useMemo)(() => {
    if (rules != null && isSingleRule) {
      return 'data_view_id' in rules[0] && rules[0].data_view_id || null;
    }
    return `security-solution-${activeSpaceId}`;
  }, [isSingleRule, rules, activeSpaceId]);
  const memoNonDataViewIndexPatterns = (0, _react.useMemo)(() => {
    if (rules != null && isSingleRule && rules[0].type === 'esql') {
      return (0, _securitysolutionUtils.getIndexListFromEsqlQuery)(rules === null || rules === void 0 ? void 0 : rules[0].query);
    }
    return !memoDataViewId && rules != null && isSingleRule && 'index' in rules[0] && rules[0].index != null ? rules[0].index : [];
  }, [memoDataViewId, isSingleRule, rules]);

  // Index pattern logic for ML
  const memoMlJobIds = (0, _react.useMemo)(() => {
    if (isMLRule && isSingleRule && rules != null) {
      var _getMachineLearningJo;
      return (_getMachineLearningJo = (0, _helpers.getMachineLearningJobId)(rules[0])) !== null && _getMachineLearningJo !== void 0 ? _getMachineLearningJo : [];
    }
    return [];
  }, [isMLRule, isSingleRule, rules]);
  const {
    mlJobLoading,
    ruleIndices: mlRuleIndices
  } = (0, _use_rule_indices.useRuleIndices)(memoMlJobIds);

  // We only want to provide a non empty array if it's an ML rule and we were able to fetch
  // the index patterns, or if it's a rule not using data views. Otherwise, return an empty
  // empty array to avoid making the `useFetchIndex` call
  const memoRuleIndices = (0, _react.useMemo)(() => {
    if (isMLRule && mlRuleIndices.length > 0) {
      return mlRuleIndices;
    } else if (memoDataViewId != null) {
      return [];
    } else {
      return memoNonDataViewIndexPatterns;
    }
  }, [isMLRule, memoDataViewId, memoNonDataViewIndexPatterns, mlRuleIndices]);
  const [isIndexPatternLoading, {
    indexPatterns: indexIndexPatterns,
    dataView: indexDataViewSpec
  }] = (0, _source.useFetchIndex)(memoRuleIndices, false, 'indexFields');

  // Data view logic
  const [dataViewIndexPatterns, setDataViewIndexPatterns] = (0, _react.useState)(null);
  const [dataViewSpec, setDataViewSpec] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const fetchSingleDataView = async () => {
      // ensure the memoized data view includes a space id, otherwise
      // we could be trying to fetch a data view that does not exist, which would
      // throw an error here.
      if (activeSpaceId !== '' && memoDataViewId) {
        setDataViewLoading(true);
        const dv = await data.dataViews.get(memoDataViewId);
        setDataViewLoading(false);
        setDataViewIndexPatterns(dv);
        setDataViewSpec(dv.toSpec());
      }
    };
    fetchSingleDataView();
  }, [memoDataViewId, data.dataViews, setDataViewIndexPatterns, activeSpaceId]);

  // Fetch extended fields information
  const getExtendedFields = (0, _react.useCallback)(async fields => {
    let extendedFields = [];
    const dv = dataViewSpec !== null && dataViewSpec !== void 0 ? dataViewSpec : indexDataViewSpec;
    if (!dv) {
      return extendedFields;
    }
    try {
      extendedFields = await data.dataViews.getFieldsForIndexPattern(dv, {
        pattern: '',
        includeUnmapped: true,
        fields
      });
    } catch (error) {
      addWarning(error, {
        title: i18n.FETCH_FIELDS_WITH_UNMAPPED_DATA_ERROR
      });
    }
    return extendedFields;
  }, [addWarning, data.dataViews, dataViewSpec, indexDataViewSpec]);

  // Determine whether to use index patterns or data views
  const indexPatternsToUse = (0, _react.useMemo)(() => memoDataViewId && dataViewIndexPatterns != null ? dataViewIndexPatterns : indexIndexPatterns, [memoDataViewId, dataViewIndexPatterns, indexIndexPatterns]);
  return {
    isLoading: isIndexPatternLoading || mlJobLoading || dataViewLoading,
    indexPatterns: indexPatternsToUse,
    getExtendedFields
  };
};
exports.useFetchIndexPatterns = useFetchIndexPatterns;