"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unRegisterProviderHandler = exports.registerProviderHandler = exports.initialDragAndDropState = exports.dragAndDropReducer = void 0;
var _fp = require("lodash/fp");
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialDragAndDropState = {
  dataProviders: {}
};
exports.initialDragAndDropState = initialDragAndDropState;
const registerProviderHandler = ({
  provider,
  dataProviders
}) => ({
  ...dataProviders,
  [provider.id]: provider
});
exports.registerProviderHandler = registerProviderHandler;
const unRegisterProviderHandler = ({
  id,
  dataProviders
}) => (0, _fp.omit)(id, dataProviders);
exports.unRegisterProviderHandler = unRegisterProviderHandler;
const dragAndDropReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialDragAndDropState).case(_actions.registerProvider, (state, {
  provider
}) => ({
  ...state,
  dataProviders: registerProviderHandler({
    provider,
    dataProviders: state.dataProviders
  })
})).case(_actions.unRegisterProvider, (state, {
  id
}) => ({
  ...state,
  dataProviders: unRegisterProviderHandler({
    id,
    dataProviders: state.dataProviders
  })
})).build();
exports.dragAndDropReducer = dragAndDropReducer;