"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Client which aggregate all the available telemetry tracking functions
 * for the plugin
 */
class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "reportAlertsGroupingChanged", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AlertsGroupingChanged, params);
    });
    (0, _defineProperty2.default)(this, "reportAlertsGroupingToggled", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AlertsGroupingToggled, params);
    });
    (0, _defineProperty2.default)(this, "reportAlertsGroupingTakeAction", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AlertsGroupingTakeAction, params);
    });
    (0, _defineProperty2.default)(this, "reportAssistantInvoked", ({
      conversationId,
      invokedBy
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AssistantInvoked, {
        conversationId,
        invokedBy
      });
    });
    (0, _defineProperty2.default)(this, "reportAssistantMessageSent", ({
      conversationId,
      role
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AssistantMessageSent, {
        conversationId,
        role
      });
    });
    (0, _defineProperty2.default)(this, "reportAssistantQuickPrompt", ({
      conversationId,
      promptTitle
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AssistantQuickPrompt, {
        conversationId,
        promptTitle
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityDetailsClicked", ({
      entity
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.EntityDetailsClicked, {
        entity
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityAlertsClicked", ({
      entity
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.EntityAlertsClicked, {
        entity
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityRiskFiltered", ({
      entity,
      selectedSeverity
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.EntityRiskFiltered, {
        entity,
        selectedSeverity
      });
    });
    (0, _defineProperty2.default)(this, "reportMLJobUpdate", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.MLJobUpdate, params);
    });
    (0, _defineProperty2.default)(this, "reportCellActionClicked", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.CellActionClicked, params);
    });
    (0, _defineProperty2.default)(this, "reportAnomaliesCountClicked", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.AnomaliesCountClicked, params);
    });
    (0, _defineProperty2.default)(this, "reportDataQualityIndexChecked", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.DataQualityIndexChecked, params);
    });
    (0, _defineProperty2.default)(this, "reportDataQualityCheckAllCompleted", params => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.DataQualityCheckAllCompleted, params);
    });
    (0, _defineProperty2.default)(this, "reportBreadcrumbClicked", ({
      title
    }) => {
      this.analytics.reportEvent(_constants.TelemetryEventTypes.BreadcrumbClicked, {
        title
      });
    });
    this.analytics = analytics;
  }
}
exports.TelemetryClient = TelemetryClient;