"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryEvents = void 0;
var _constants = require("../constants");
var _alerts_grouping = require("./alerts_grouping");
var _entity_analytics = require("./entity_analytics");
var _ai_assistant = require("./ai_assistant");
var _data_quality = require("./data_quality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mlJobUpdateEvent = {
  eventType: _constants.TelemetryEventTypes.MLJobUpdate,
  schema: {
    jobId: {
      type: 'keyword',
      _meta: {
        description: 'Job id',
        optional: false
      }
    },
    isElasticJob: {
      type: 'boolean',
      _meta: {
        description: 'If true the job is one of the pre-configure security solution modules',
        optional: false
      }
    },
    moduleId: {
      type: 'keyword',
      _meta: {
        description: 'Module id',
        optional: true
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'It describes what has changed in the job.',
        optional: false
      }
    },
    errorMessage: {
      type: 'text',
      _meta: {
        description: 'Error message',
        optional: true
      }
    }
  }
};
const cellActionClickedEvent = {
  eventType: _constants.TelemetryEventTypes.CellActionClicked,
  schema: {
    fieldName: {
      type: 'keyword',
      _meta: {
        description: 'Field Name',
        optional: false
      }
    },
    actionId: {
      type: 'keyword',
      _meta: {
        description: 'Action id',
        optional: false
      }
    },
    displayName: {
      type: 'keyword',
      _meta: {
        description: 'User friendly action name',
        optional: false
      }
    },
    metadata: {
      type: 'pass_through',
      _meta: {
        description: 'Action metadata',
        optional: true
      }
    }
  }
};
const anomaliesCountClickedEvent = {
  eventType: _constants.TelemetryEventTypes.AnomaliesCountClicked,
  schema: {
    jobId: {
      type: 'keyword',
      _meta: {
        description: 'Job id',
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of anomalies',
        optional: false
      }
    }
  }
};
const breadCrumbClickedEvent = {
  eventType: _constants.TelemetryEventTypes.BreadcrumbClicked,
  schema: {
    title: {
      type: 'keyword',
      _meta: {
        description: 'Breadcrumb title',
        optional: false
      }
    }
  }
};
const telemetryEvents = [_alerts_grouping.alertsGroupingToggledEvent, _alerts_grouping.alertsGroupingChangedEvent, _alerts_grouping.alertsGroupingTakeActionEvent, _ai_assistant.assistantInvokedEvent, _ai_assistant.assistantMessageSentEvent, _ai_assistant.assistantQuickPrompt, _entity_analytics.entityClickedEvent, _entity_analytics.entityAlertsClickedEvent, _entity_analytics.entityRiskFilteredEvent, mlJobUpdateEvent, cellActionClickedEvent, anomaliesCountClickedEvent, _data_quality.dataQualityIndexCheckedEvent, _data_quality.dataQualityCheckAllClickedEvent, breadCrumbClickedEvent];
exports.telemetryEvents = telemetryEvents;