"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateBrowserTitle = void 0;
var _react = require("react");
var _nav_links = require("../links/nav_links");
var _use_find_app_links_by_path = require("../links/use_find_app_links_by_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateBrowserTitle = () => {
  const navLinks = (0, _nav_links.useNavLinks)();
  const linkInfo = (0, _use_find_app_links_by_path.useFindAppLinksByPath)(navLinks);
  (0, _react.useEffect)(() => {
    var _linkInfo$title;
    document.title = `${(_linkInfo$title = linkInfo === null || linkInfo === void 0 ? void 0 : linkInfo.title) !== null && _linkInfo$title !== void 0 ? _linkInfo$title : ''} - Kibana`;
  }, [linkInfo]);
};
exports.useUpdateBrowserTitle = useUpdateBrowserTitle;