"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResolveConflict = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _rison = require("@kbn/rison");
var _use_selector = require("./use_selector");
var _timeline = require("../../../common/types/timeline");
var _timeline2 = require("../../timelines/store/timeline");
var _defaults = require("../../timelines/store/timeline/defaults");
var _kibana = require("../lib/kibana");
var _use_url_state = require("./use_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Unfortunately the url change initiated when clicking the button to otherObjectPath doesn't seem to be
 * respected by the useSetInitialStateFromUrl here: x-pack/plugins/security_solution/public/common/components/url_state/initialize_redux_by_url.tsx
 *
 * FYI: It looks like the routing causes replaceStateInLocation to be called instead:
 * x-pack/plugins/security_solution/public/common/components/url_state/helpers.ts
 *
 * Potentially why the markdown component needs a click handler as well for timeline?
 * see: /x-pack/plugins/security_solution/public/common/components/markdown_editor/plugins/timeline/processor.tsx
 */
const useResolveConflict = () => {
  const {
    search,
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    spaces
  } = (0, _kibana.useKibana)().services;
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    resolveTimelineConfig,
    savedObjectId,
    show,
    graphEventId,
    activeTab
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
  });
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    var _searchQuery$get, _ref, _resolveTimelineConfi;
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario

    const searchQuery = new URLSearchParams(search);
    const timelineRison = (_searchQuery$get = searchQuery.get(_use_url_state.URL_PARAM_KEY.timeline)) !== null && _searchQuery$get !== void 0 ? _searchQuery$get : undefined;
    // Try to get state on URL, but default to what's in Redux in case of decodeRisonFailure
    const currentTimelineState = {
      id: savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : '',
      isOpen: !!show,
      activeTab,
      graphEventId
    };
    const timelineSearch = (_ref = (0, _rison.safeDecode)(timelineRison !== null && timelineRison !== void 0 ? timelineRison : '')) !== null && _ref !== void 0 ? _ref : currentTimelineState;

    // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
    // callout with a warning for the user, and provide a way for them to navigate to the other object.
    const currentObjectId = timelineSearch === null || timelineSearch === void 0 ? void 0 : timelineSearch.id;
    if (!spaces || (resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.outcome) !== 'conflict' || (resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id) == null || currentObjectId == null) {
      return null;
    }
    const newSavedObjectId = (_resolveTimelineConfi = resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id) !== null && _resolveTimelineConfi !== void 0 ? _resolveTimelineConfi : ''; // This is always defined if outcome === 'conflict'

    const newTimelineSearch = {
      ...timelineSearch,
      id: newSavedObjectId
    };
    const newTimelineRison = (0, _rison.encode)(newTimelineSearch);
    searchQuery.set(_use_url_state.URL_PARAM_KEY.timeline, newTimelineRison);
    const newPath = `${pathname}?${searchQuery.toString()}${window.location.hash}`;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, spaces.ui.components.getLegacyUrlConflict({
      objectNoun: _use_url_state.URL_PARAM_KEY.timeline,
      currentObjectId,
      otherObjectId: newSavedObjectId,
      otherObjectPath: newPath
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }, [activeTab, graphEventId, pathname, resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id, resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.outcome, savedObjectId, search, show, spaces]);
  return (0, _react.useMemo)(() => getLegacyUrlConflictCallout(), [getLegacyUrlConflictCallout]);
};
exports.useResolveConflict = useResolveConflict;