"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.demoEndpointProcessExecutionMalwarePreventionAlert = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const demoEndpointProcessExecutionMalwarePreventionAlert = {
  process: {
    hash: {
      md5: ['177afc1eb0be88eb9983fb74111260c4'],
      sha256: ['3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb'],
      sha1: ['f573b85e9beb32121f1949217947b2adc6749e3d']
    },
    entity_id: ['MWQxNWNmOWUtM2RjNy01Yjk3LWY1ODYtNzQzZjdjMjUxOGIyLTY5MjAtMTMyNDg5OTk2OTAuNDgzMzA3NzAw'],
    executable: ['C:\\Users\\sean\\Downloads\\3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb.exe'],
    name: ['C:\\Users\\sean\\Downloads\\3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb.exe'],
    pid: [6920],
    args: ['C:\\Users\\sean\\Downloads\\3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb.exe']
  },
  host: {
    os: {
      full: ['Windows Server 2019 Datacenter 1809 (10.0.17763.1518)'],
      name: ['Windows'],
      version: ['1809 (10.0.17763.1518)'],
      platform: ['windows'],
      family: ['windows'],
      kernel: ['1809 (10.0.17763.1518)']
    },
    mac: ['aa:bb:cc:dd:ee:ff'],
    architecture: ['x86_64'],
    ip: ['10.1.2.3'],
    id: ['d8ad572e-d224-4044-a57d-f5a84c0dfe5d'],
    name: ['win2019-endpoint-1']
  },
  file: {
    mtime: ['2020-11-04T21:40:51.494Z'],
    path: ['C:\\Users\\sean\\Downloads\\3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb.exe'],
    owner: ['sean'],
    hash: {
      md5: ['177afc1eb0be88eb9983fb74111260c4'],
      sha256: ['3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb'],
      sha1: ['f573b85e9beb32121f1949217947b2adc6749e3d']
    },
    name: ['3be13acde2f4dcded4fd8d518a513bfc9882407a6e384ffb17d12710db7d76fb.exe'],
    extension: ['exe'],
    size: [1604112]
  },
  event: {
    category: ['malware', 'intrusion_detection', 'process'],
    outcome: ['success'],
    severity: [73],
    code: ['malicious_file'],
    action: ['execution'],
    id: ['LsuMZVr+sdhvehVM++++Gp2Y'],
    kind: ['alert'],
    created: ['2020-11-04T21:41:30.533Z'],
    module: ['endpoint'],
    type: ['info', 'start', 'denied'],
    dataset: ['endpoint.alerts']
  },
  agent: {
    type: ['endpoint']
  },
  timestamp: '2020-11-04T21:41:30.533Z',
  message: ['Malware Prevention Alert'],
  _id: '0dA2lXUBn9bLIbfPkY7d'
};
exports.demoEndpointProcessExecutionMalwarePreventionAlert = demoEndpointProcessExecutionMalwarePreventionAlert;