"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMatrixHistogramCombined = exports.useMatrixHistogram = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _fp = require("lodash/fp");
var _react = require("react");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _helpers = require("../helpers");
var _kibana = require("../../lib/kibana");
var _security_solution = require("../../../../common/search_strategy/security_solution");
var _helpers2 = require("../../../helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../hooks/use_app_toasts");
var _use_track_http_request = require("../../lib/apm/use_track_http_request");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bucketEmpty = [];
const useMatrixHistogram = ({
  endDate,
  errorMessage,
  filterQuery,
  histogramType,
  indexNames,
  isPtrIncluded,
  onError,
  stackByField,
  runtimeMappings,
  startDate,
  threshold,
  skip = false,
  includeMissingData = true
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const refetch = (0, _react.useRef)(_fp.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [loading, setLoading] = (0, _react.useState)(false);
  const {
    startTracking
  } = (0, _use_track_http_request.useTrackHttpRequest)();
  const [matrixHistogramRequest, setMatrixHistogramRequest] = (0, _react.useState)({
    defaultIndex: indexNames,
    factoryQueryType: _security_solution.MatrixHistogramQuery,
    filterQuery: (0, _helpers.createFilter)(filterQuery),
    histogramType: histogramType !== null && histogramType !== void 0 ? histogramType : histogramType,
    timerange: {
      interval: '12h',
      from: startDate,
      to: endDate
    },
    stackByField,
    runtimeMappings,
    threshold,
    ...(isPtrIncluded != null ? {
      isPtrIncluded
    } : {}),
    ...(includeMissingData != null ? {
      includeMissingData
    } : {})
  });
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [matrixHistogramResponse, setMatrixHistogramResponse] = (0, _react.useState)({
    data: [],
    inspect: {
      dsl: [],
      response: []
    },
    refetch: refetch.current,
    totalCount: -1,
    buckets: []
  });
  const search = (0, _react.useCallback)(request => {
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      setLoading(true);
      const {
        endTracking
      } = startTracking({
        name: `${_constants.APP_UI_ID} matrixHistogram ${histogramType}`
      });
      searchSubscription$.current = data.search.search(request, {
        strategy: 'securitySolutionSearchStrategy',
        abortSignal: abortCtrl.current.signal
      }).subscribe({
        next: response => {
          if (!(0, _common.isRunningResponse)(response)) {
            const histogramBuckets = (0, _fp.getOr)(bucketEmpty, _security_solution.MatrixHistogramTypeToAggName[histogramType], response.rawResponse);
            setLoading(false);
            setMatrixHistogramResponse(prevResponse => ({
              ...prevResponse,
              data: response.matrixHistogramData,
              inspect: (0, _helpers2.getInspectResponse)(response, prevResponse.inspect),
              refetch: refetch.current,
              totalCount: histogramBuckets.reduce((acc, bucket) => bucket.doc_count + acc, 0),
              buckets: histogramBuckets
            }));
            endTracking('success');
            searchSubscription$.current.unsubscribe();
          }
        },
        error: msg => {
          setLoading(false);
          addError(msg, {
            title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : i18n.FAIL_MATRIX_HISTOGRAM
          });
          endTracking('error');
          searchSubscription$.current.unsubscribe();
        }
      });
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [data.search, histogramType, addError, errorMessage, startTracking]);
  (0, _react.useEffect)(() => {
    setMatrixHistogramRequest(prevRequest => {
      const myRequest = {
        ...prevRequest,
        defaultIndex: indexNames,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        histogramType,
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        stackByField,
        threshold,
        ...(isPtrIncluded != null ? {
          isPtrIncluded
        } : {})
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [indexNames, endDate, filterQuery, startDate, stackByField, histogramType, threshold, isPtrIncluded]);
  (0, _react.useEffect)(() => {
    // We want to search if it is not skipped, stackByField ends with ip and include missing data
    if (!skip) {
      search(matrixHistogramRequest);
    }
    return () => {
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    };
  }, [matrixHistogramRequest, search, skip]);
  (0, _react.useEffect)(() => {
    if (skip) {
      setLoading(false);
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    }
  }, [skip]);
  const runMatrixHistogramSearch = (0, _react.useCallback)((to, from) => {
    search({
      ...matrixHistogramRequest,
      timerange: {
        interval: '12h',
        from,
        to
      }
    });
  }, [matrixHistogramRequest, search]);
  return [loading, matrixHistogramResponse, runMatrixHistogramSearch];
};

/* function needed to split ip histogram data requests due to elasticsearch bug https://github.com/elastic/kibana/issues/89205
 * using includeMissingData parameter to do the "missing data" query separately
 **/
exports.useMatrixHistogram = useMatrixHistogram;
const useMatrixHistogramCombined = matrixHistogramQueryProps => {
  const [mainLoading, mainResponse] = useMatrixHistogram({
    ...matrixHistogramQueryProps,
    includeMissingData: true
  });
  const skipMissingData = (0, _react.useMemo)(() => !matrixHistogramQueryProps.stackByField.endsWith('.ip'), [matrixHistogramQueryProps.stackByField]);
  const [missingDataLoading, missingDataResponse] = useMatrixHistogram({
    ...matrixHistogramQueryProps,
    includeMissingData: false,
    skip: skipMissingData || matrixHistogramQueryProps.filterQuery === undefined || matrixHistogramQueryProps.skip
  });
  const combinedLoading = (0, _react.useMemo)(() => mainLoading || missingDataLoading, [mainLoading, missingDataLoading]);
  const combinedResponse = (0, _react.useMemo)(() => {
    if (skipMissingData) return mainResponse;
    const {
      data,
      inspect,
      totalCount,
      refetch,
      buckets
    } = mainResponse;
    const {
      data: extraData,
      inspect: extraInspect,
      totalCount: extraTotalCount,
      refetch: extraRefetch
    } = missingDataResponse;
    const combinedRefetch = () => {
      refetch();
      extraRefetch();
    };
    if (combinedLoading) {
      return {
        data: [],
        inspect: {
          dsl: [],
          response: []
        },
        refetch: combinedRefetch,
        totalCount: -1,
        buckets: []
      };
    }
    return {
      data: [...data, ...extraData],
      inspect: {
        dsl: [...inspect.dsl, ...extraInspect.dsl],
        response: [...inspect.response, ...extraInspect.response]
      },
      totalCount: totalCount + extraTotalCount,
      refetch: combinedRefetch,
      buckets
    };
  }, [combinedLoading, mainResponse, missingDataResponse, skipMissingData]);
  return [combinedLoading, combinedResponse];
};
exports.useMatrixHistogramCombined = useMatrixHistogramCombined;