"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVariation = exports.useThrottledResizeObserver = exports.histogramDateTimeFormatter = exports.getDaysDiff = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _polyfilled = _interopRequireDefault(require("use-resize-observer/polyfilled"));
var _charts = require("@elastic/charts");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDaysDiff = (minDate, maxDate) => {
  const diff = maxDate.diff(minDate, 'days');
  if (diff <= 1 && !minDate.isSame(maxDate)) {
    return 2; // to return proper pattern from niceTimeFormatByDay
  }

  return diff;
};
exports.getDaysDiff = getDaysDiff;
const histogramDateTimeFormatter = (domain, fixedDiff) => {
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const diff = fixedDiff !== null && fixedDiff !== void 0 ? fixedDiff : getDaysDiff((0, _momentTimezone.default)(domain[0]), (0, _momentTimezone.default)(domain[1]));
  const format = (0, _charts.niceTimeFormatByDay)(diff);
  return (0, _charts.timeFormatter)(format);
};
exports.histogramDateTimeFormatter = histogramDateTimeFormatter;
const useThrottledResizeObserver = (wait = 100) => {
  const [size, setSize] = (0, _react.useState)({
    width: 0,
    height: 0
  });
  const onResize = (0, _react.useMemo)(() => (0, _fp.throttle)(wait, setSize), [wait]);
  const {
    ref
  } = (0, _polyfilled.default)({
    onResize
  });
  return {
    ref,
    ...size
  };
};

/**
 * Retrieves the variation of the feature flag if the cloudExperiments plugin is enabled.
 * @param cloudExperiments {@link CloudExperimentsPluginStart}
 * @param featureFlagName The name of the feature flag {@link CloudExperimentsFeatureFlagNames}
 * @param defaultValue The default value in case it cannot retrieve the feature flag
 * @param setter The setter from {@link useState} to update the value.
 */
exports.useThrottledResizeObserver = useThrottledResizeObserver;
const useVariation = (cloudExperiments, featureFlagName, defaultValue, setter) => {
  (0, _react.useEffect)(() => {
    (async function loadVariation() {
      const variationUrl = await (cloudExperiments === null || cloudExperiments === void 0 ? void 0 : cloudExperiments.getVariation(featureFlagName, defaultValue));
      if (variationUrl) {
        setter(variationUrl);
      }
    })();
  }, [cloudExperiments, featureFlagName, defaultValue, setter]);
};
exports.useVariation = useVariation;