"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSuggestUsers = exports.bulkGetUserProfiles = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("./api");
var _translations = require("./translations");
var _use_app_toasts = require("../../hooks/use_app_toasts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkGetUserProfiles = async ({
  searchTerm
}) => {
  return (0, _api.suggestUsers)({
    searchTerm
  });
};
exports.bulkGetUserProfiles = bulkGetUserProfiles;
const useSuggestUsers = ({
  searchTerm
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['useSuggestUsers', searchTerm], async () => {
    return bulkGetUserProfiles({
      searchTerm
    });
  }, {
    retry: false,
    staleTime: Infinity,
    onError: e => {
      addError(e, {
        title: _translations.USER_PROFILES_FAILURE
      });
    }
  });
};
exports.useSuggestUsers = useSuggestUsers;