"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetAlertAssignees = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../../containers/alert_assignees/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Update alert assignees by query
 *
 * @param assignees to add and/or remove from a batch of alerts
 * @param ids alert ids that will be used to create the update query.
 * @param onSuccess a callback function that will be called on successful api response
 * @param setTableLoading a function that sets the alert table in a loading state for bulk actions

 *
 * @throws An error if response is not OK
 */
const useSetAlertAssignees = () => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const setAlertAssigneesRef = (0, _react.useRef)(null);
  const onUpdateSuccess = (0, _react.useCallback)((updated = 0) => addSuccess(i18n.UPDATE_ALERT_ASSIGNEES_SUCCESS_TOAST(updated)), [addSuccess]);
  const onUpdateFailure = (0, _react.useCallback)(error => {
    addError(error.message, {
      title: i18n.UPDATE_ALERT_ASSIGNEES_FAILURE
    });
  }, [addError]);
  (0, _react.useEffect)(() => {
    let ignore = false;
    const abortCtrl = new AbortController();
    const onSetAlertAssignees = async (assignees, ids, onSuccess, setTableLoading) => {
      try {
        setTableLoading(true);
        const response = await (0, _api.setAlertAssignees)({
          assignees,
          ids,
          signal: abortCtrl.signal
        });
        if (!ignore) {
          onSuccess();
          setTableLoading(false);
          onUpdateSuccess(response.updated);
        }
      } catch (error) {
        if (!ignore) {
          setTableLoading(false);
          onUpdateFailure(error);
        }
      }
    };
    setAlertAssigneesRef.current = onSetAlertAssignees;
    return () => {
      ignore = true;
      abortCtrl.abort();
    };
  }, [http, onUpdateFailure, onUpdateSuccess]);
  return setAlertAssigneesRef.current;
};
exports.useSetAlertAssignees = useSetAlertAssignees;