"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateDataView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana = require("../../lib/kibana");
var _constants = require("../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _refresh_button = require("./refresh_button");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var _sourcerer = require("../../../../common/utils/sourcerer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateDataView = onOpenAndReset => {
  const {
    theme,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _react.useCallback)(async missingPatterns => {
    const asyncSearch = async () => {
      try {
        const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
        const uiSettingsIndexPattern = [...defaultPatterns, ...missingPatterns];
        const isSuccess = await uiSettings.set(_constants.DEFAULT_INDEX_KEY, (0, _sourcerer.ensurePatternFormat)(uiSettingsIndexPattern));
        return [isSuccess, null];
      } catch (e) {
        return [false, e];
      }
    };
    const [isUiSettingsSuccess, possibleError] = await asyncSearch();
    if (isUiSettingsSuccess) {
      addSuccess({
        color: 'success',
        title: (0, _public.toMountPoint)(i18n.SUCCESS_TOAST_TITLE, {
          theme$: theme.theme$
        }),
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_refresh_button.RefreshButton, null), {
          theme$: theme.theme$
        }),
        iconType: undefined,
        toastLifeTimeMs: 600000
      });
      return true;
    }
    addError(possibleError !== null ? possibleError : new Error(i18n.FAILURE_TOAST_TITLE), {
      title: i18n.FAILURE_TOAST_TITLE,
      toastMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.indexPatterns.failureToastText",
        defaultMessage: "Unexpected error occurred on update. If you would like to modify your data, you can manually select a data view {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: onOpenAndReset,
            "data-test-subj": "failureToastLink"
          }, i18n.TOGGLE_TO_NEW_SOURCERER)
        }
      }))
    });
    return false;
  }, [addError, addSuccess, onOpenAndReset, theme.theme$, uiSettings]);
};
exports.useUpdateDataView = useUpdateDataView;