"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerComponent = exports.Trigger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TriggerComponent = ({
  activePatterns,
  disabled,
  isModified,
  isOnlyDetectionAlerts,
  isPopoverOpen,
  isTimelineSourcerer,
  loading,
  onClick,
  selectedPatterns,
  signalIndexName
}) => {
  const badge = (0, _react.useMemo)(() => {
    switch (isModified) {
      case 'modified':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          "data-test-subj": "sourcerer-modified-badge"
        }, i18n.MODIFIED_BADGE_TITLE);
      case 'alerts':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          "data-test-subj": "sourcerer-alerts-badge"
        }, i18n.ALERTS_BADGE_TITLE);
      case 'deprecated':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          color: "warning",
          "data-test-subj": "sourcerer-deprecated-badge"
        }, i18n.DEPRECATED_BADGE_TITLE);
      case 'missingPatterns':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          color: "warning",
          "data-test-subj": "sourcerer-missingPatterns-badge"
        }, i18n.DEPRECATED_BADGE_TITLE);
      case '':
      default:
        return null;
    }
  }, [isModified]);
  const Button = (0, _react.useMemo)(() => isTimelineSourcerer ? _eui.EuiButton : _helpers.StyledButtonEmpty, [isTimelineSourcerer]);
  const trigger = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(Button, {
    "aria-label": i18n.DATA_VIEW,
    "data-test-subj": isTimelineSourcerer ? 'timeline-sourcerer-trigger' : 'sourcerer-trigger',
    color: "primary",
    iconSide: "right",
    iconType: "arrowDown",
    disabled: disabled,
    isLoading: loading,
    onClick: onClick,
    title: i18n.DATA_VIEW
  }, i18n.DATA_VIEW, !disabled && badge), [disabled, badge, isTimelineSourcerer, loading, onClick, Button]);
  const tooltipContent = (0, _react.useMemo)(() => disabled ? i18n.DISABLED_SOURCERER : (0, _helpers.getTooltipContent)({
    isOnlyDetectionAlerts,
    isPopoverOpen,
    // if activePatterns, use because we are in the temporary sourcerer state
    selectedPatterns: activePatterns !== null && activePatterns !== void 0 ? activePatterns : selectedPatterns,
    signalIndexName
  }), [activePatterns, disabled, isOnlyDetectionAlerts, isPopoverOpen, selectedPatterns, signalIndexName]);
  return tooltipContent ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipContent,
    "data-test-subj": "sourcerer-tooltip"
  }, trigger) : trigger;
};
exports.TriggerComponent = TriggerComponent;
const Trigger = /*#__PURE__*/(0, _react.memo)(TriggerComponent);
exports.Trigger = Trigger;