"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showNewsItem = exports.removeSuffixFromVersion = exports.getNewsItemsFromApiResponse = exports.getNewsFeedUrl = exports.getLocale = exports.fetchNews = exports.NEWS_FEED_FALLBACK_LANGUAGE = void 0;
var _fp = require("lodash/fp");
var _moment = _interopRequireDefault(require("moment"));
var _uuid = require("uuid");
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Removes the suffix that is sometimes appended to the Kibana version,
 * (e.g. `8.0.0-SNAPSHOT-rc1`), which is typically only seen in non-production
 * environments
 */
const removeSuffixFromVersion = kibanaVersion => {
  var _semverCoerce$version, _semverCoerce;
  return (_semverCoerce$version = (_semverCoerce = (0, _coerce.default)(kibanaVersion)) === null || _semverCoerce === void 0 ? void 0 : _semverCoerce.version) !== null && _semverCoerce$version !== void 0 ? _semverCoerce$version : kibanaVersion;
};

/**
 * Combines the URL specified in the `newsFeedUrlSetting`, e.g.
 * `https://feeds.elastic.co/security-solution` with the Kibana version
 * returned from `getKibanaVersion` (e.g. `8.0.0`) to form a complete path to
 * the news specific to the current version of Kibana, (e.g.
 * `https://feeds.elastic.co/security-solution/v8.0.0.json`)
 */
exports.removeSuffixFromVersion = removeSuffixFromVersion;
const getNewsFeedUrl = ({
  newsFeedUrlSetting,
  getKibanaVersion
}) => [newsFeedUrlSetting === null || newsFeedUrlSetting === void 0 ? void 0 : newsFeedUrlSetting.trim().replace(/\/$/, ''), `v${removeSuffixFromVersion(getKibanaVersion())}.json`].join('/');

/** Fall back to this language when extracting i18n news items from the feed */
exports.getNewsFeedUrl = getNewsFeedUrl;
const NEWS_FEED_FALLBACK_LANGUAGE = 'en';

/**
 * Returns the current locale of the browser as specified in the `document`,
 * or the value of `fallback` if the locale could not be retrieved
 */
exports.NEWS_FEED_FALLBACK_LANGUAGE = NEWS_FEED_FALLBACK_LANGUAGE;
const getLocale = fallback => {
  var _document$documentEle;
  if (document.documentElement.lang === '') {
    return fallback;
  }
  return (_document$documentEle = document.documentElement.lang) !== null && _document$documentEle !== void 0 ? _document$documentEle : fallback; // use the `lang` attribute of the `html` tag
};
exports.getLocale = getLocale;
const NO_NEWS_ITEMS = [];

/**
 * Transforms a `RawNewsApiResponse` from the news feed API to a collection of
 * `NewsItem`s
 */
const getNewsItemsFromApiResponse = response => {
  const locale = getLocale(NEWS_FEED_FALLBACK_LANGUAGE);
  if (response == null || response.items == null) {
    return NO_NEWS_ITEMS;
  }
  return response.items.filter(x => x != null).map(x => {
    var _ref, _get, _x$expire_on, _x$hash, _ref2, _get2, _ref3, _get3, _x$publish_on, _ref4, _get4;
    return {
      description: (_ref = (_get = (0, _fp.get)(locale, x.description)) !== null && _get !== void 0 ? _get : (0, _fp.get)(NEWS_FEED_FALLBACK_LANGUAGE, x.description)) !== null && _ref !== void 0 ? _ref : '',
      expireOn: new Date((_x$expire_on = x.expire_on) !== null && _x$expire_on !== void 0 ? _x$expire_on : ''),
      hash: (_x$hash = x.hash) !== null && _x$hash !== void 0 ? _x$hash : (0, _uuid.v4)(),
      imageUrl: (_ref2 = (_get2 = (0, _fp.get)(locale, x.image_url)) !== null && _get2 !== void 0 ? _get2 : (0, _fp.get)(NEWS_FEED_FALLBACK_LANGUAGE, x.image_url)) !== null && _ref2 !== void 0 ? _ref2 : null,
      linkUrl: (_ref3 = (_get3 = (0, _fp.get)(locale, x.link_url)) !== null && _get3 !== void 0 ? _get3 : (0, _fp.get)(NEWS_FEED_FALLBACK_LANGUAGE, x.link_url)) !== null && _ref3 !== void 0 ? _ref3 : '',
      publishOn: new Date((_x$publish_on = x.publish_on) !== null && _x$publish_on !== void 0 ? _x$publish_on : ''),
      title: (_ref4 = (_get4 = (0, _fp.get)(locale, x.title)) !== null && _get4 !== void 0 ? _get4 : (0, _fp.get)(NEWS_FEED_FALLBACK_LANGUAGE, x.title)) !== null && _ref4 !== void 0 ? _ref4 : ''
    };
  });
};

/**
 * Fetches `RawNewsApiResponse` from the specified `newsFeedUrl`, via a
 * cross-origin (CORS) request. This function throws an error if the request
 * fails
 */
exports.getNewsItemsFromApiResponse = getNewsItemsFromApiResponse;
const fetchNews = async ({
  newsFeedUrl
}) => {
  return _kibana.KibanaServices.get().http.fetch(newsFeedUrl, {
    method: 'GET',
    credentials: 'omit',
    mode: 'cors'
  });
};

/**
 * Returns true when "now" is after the publishOn date and before the expireOn
 * date
 */
exports.fetchNews = fetchNews;
const showNewsItem = ({
  publishOn,
  expireOn
}) => (0, _moment.default)(Date.now()).isAfter(publishOn) && (0, _moment.default)(Date.now()).isBefore(expireOn);
exports.showNewsItem = showNewsItem;