"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeContentsComponent = exports.UpgradeContents = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverContentsDiv = _styledComponents.default.div`
  width: 384px;
`;
PopoverContentsDiv.displayName = 'PopoverContentsDiv';
const UpgradeContentsComponent = () => /*#__PURE__*/_react.default.createElement(PopoverContentsDiv, {
  "data-test-subj": "ml-popover-upgrade-contents"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, i18n.UPGRADE_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.components.mlPopup.upgradeDescription",
  defaultMessage: "To access SIEM\u2019s anomaly detection features, you must update your license to Platinum, start a free 30-day trial, or spin up a {cloudLink} on AWS, GCP, or Azure. You can then run Machine Learning jobs and view anomalies.",
  values: {
    cloudLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `https://www.elastic.co/cloud/`,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.components.mlPopup.cloudLink",
      defaultMessage: "cloud deployment"
    }))
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  href: "https://www.elastic.co/subscriptions",
  iconType: "popout",
  iconSide: "right",
  target: "_blank"
}, i18n.UPGRADE_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  href: `${(0, _kibana.useBasePath)()}/app/management/stack/license_management`,
  iconType: "gear",
  target: "_blank"
}, i18n.LICENSE_BUTTON))));
exports.UpgradeContentsComponent = UpgradeContentsComponent;
const UpgradeContents = /*#__PURE__*/_react.default.memo(UpgradeContentsComponent);
exports.UpgradeContents = UpgradeContents;
UpgradeContents.displayName = 'UpgradeContents';