"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPopover = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/ml-plugin/public");
var _kibana = require("../../lib/kibana");
var _helpers = require("./helpers");
var _jobs_table_filters = require("./jobs_table/filters/jobs_table_filters");
var _jobs_table = require("./jobs_table/jobs_table");
var _showing_count = require("./jobs_table/showing_count");
var _popover_description = require("./popover_description");
var i18n = _interopRequireWildcard(require("./translations"));
var _upgrade_contents = require("./upgrade_contents");
var _use_security_jobs = require("./hooks/use_security_jobs");
var _use_enable_data_feed = require("./hooks/use_enable_data_feed");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverContentsDiv = _styledComponents.default.div`
  max-width: 684px;
  max-height: 90vh;
  overflow-y: auto;
  overflow-x: hidden;
  padding-bottom: 15px;
`;
PopoverContentsDiv.displayName = 'PopoverContentsDiv';
const defaultFilterProps = {
  filterQuery: '',
  showCustomJobs: false,
  showElasticJobs: false,
  selectedGroups: []
};
const MlPopover = /*#__PURE__*/_react.default.memo(() => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [filterProperties, setFilterProperties] = (0, _react.useState)(defaultFilterProps);
  const [mlNodesAvailable, setMlNodesAvailable] = (0, _react.useState)(false);
  const {
    isMlAdmin,
    isLicensed,
    loading: isLoadingSecurityJobs,
    jobs,
    refetch: refreshJobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const {
    enableDatafeed,
    disableDatafeed,
    isLoading: isLoadingEnableDataFeed
  } = (0, _use_enable_data_feed.useEnableDataFeed)();
  const handleJobStateChange = (0, _react.useCallback)(async (job, latestTimestampMs, enable) => {
    if (enable) {
      await enableDatafeed(job, latestTimestampMs);
    } else {
      await disableDatafeed(job);
    }
    refreshJobs();
  }, [refreshJobs, enableDatafeed, disableDatafeed]);
  const filteredJobs = (0, _helpers.filterJobs)({
    jobs,
    ...filterProperties
  });
  const incompatibleJobCount = jobs.filter(j => !j.isCompatible).length;
  const installedJobsIds = (0, _react.useMemo)(() => jobs.filter(j => j.isInstalled).map(j => j.id), [jobs]);
  if (!isLicensed) {
    // If the user does not have platinum show upgrade UI
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downRight",
      id: "integrations-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
        "aria-expanded": isPopoverOpen,
        "aria-haspopup": "true",
        "aria-label": i18n.ML_JOB_SETTINGS,
        color: "primary",
        "data-test-subj": "integrations-button",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: () => setIsPopoverOpen(!isPopoverOpen),
        textProps: {
          style: {
            fontSize: '1rem'
          }
        }
      }, i18n.ML_JOB_SETTINGS),
      isOpen: isPopoverOpen,
      closePopover: () => setIsPopoverOpen(!isPopoverOpen),
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_upgrade_contents.UpgradeContents, null));
  } else if (isMlAdmin) {
    // If the user has Platinum License & ML Admin Permissions, show Anomaly Detection button & full config UI
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downRight",
      id: "integrations-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
        "aria-expanded": isPopoverOpen,
        "aria-haspopup": "true",
        "aria-label": i18n.ML_JOB_SETTINGS,
        color: "primary",
        "data-test-subj": "integrations-button",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: () => {
          setIsPopoverOpen(!isPopoverOpen);
          refreshJobs();
        },
        textProps: {
          style: {
            fontSize: '1rem'
          }
        }
      }, i18n.ML_JOB_SETTINGS),
      isOpen: isPopoverOpen,
      closePopover: () => setIsPopoverOpen(!isPopoverOpen),
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(PopoverContentsDiv, {
      "data-test-subj": "ml-popover-contents"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, i18n.ML_JOB_SETTINGS), /*#__PURE__*/_react.default.createElement(_popover_description.PopoverDescription, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_jobs_table_filters.JobsTableFilters, {
      securityJobs: jobs,
      onFilterChanged: setFilterProperties
    }), /*#__PURE__*/_react.default.createElement(_showing_count.ShowingCount, {
      filterResultsLength: filteredJobs.length
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), incompatibleJobCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.MODULE_NOT_COMPATIBLE_TITLE(incompatibleJobCount),
      color: "warning",
      iconType: "warning",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "We could not find any data, see {mlDocs} for more information on Machine Learning job requirements.",
      id: "xpack.securitySolution.components.mlPopup.moduleNotCompatibleDescription",
      values: {
        mlDocs: /*#__PURE__*/_react.default.createElement("a", {
          href: `${docLinks.links.siem.ml}`,
          rel: "noopener noreferrer",
          target: "_blank"
        }, i18n.ANOMALY_DETECTION_DOCS)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_public.MLJobsAwaitingNodeWarning, {
      jobIds: installedJobsIds
    }), /*#__PURE__*/_react.default.createElement(_public.MlNodeAvailableWarningShared, {
      size: "s",
      nodeAvailableCallback: setMlNodesAvailable
    }), /*#__PURE__*/_react.default.createElement(_jobs_table.JobsTable, {
      isLoading: isLoadingSecurityJobs || isLoadingEnableDataFeed,
      jobs: filteredJobs,
      onJobStateChange: handleJobStateChange,
      mlNodesAvailable: mlNodesAvailable
    })));
  } else {
    // If the user has Platinum License & not ML Admin, hide Anomaly Detection button as they don't have permissions to configure
    return null;
  }
});
exports.MlPopover = MlPopover;
MlPopover.displayName = 'MlPopover';