"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_NAME = exports.UNIT = exports.TOOLTIP = exports.TIME_STAMP = exports.SHOWING = exports.SCORE = exports.NETWORK_NAME = exports.JOB_ID = exports.INTERVAL_TOOLTIP = exports.INTERVAL_SHOW_ALL = exports.INTERVAL_HOUR = exports.INTERVAL_DAY = exports.INTERVAL_AUTO = exports.INTERVAL = exports.INFLUENCED_BY = exports.HOST_NAME = exports.ENTITY = exports.DETECTOR = exports.ANOMALIES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOWING = _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.showingDescription', {
  defaultMessage: 'Showing'
});
exports.SHOWING = SHOWING;
const ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.anomaliesDescription', {
  defaultMessage: 'Anomalies'
});
exports.ANOMALIES = ANOMALIES;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {anomaly} other {anomalies}}`
});
exports.UNIT = UNIT;
const TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.anomaliesTable.table.anomaliesTooltip', {
  defaultMessage: 'The anomalies table is not filterable via the SIEM global KQL search.'
});
exports.TOOLTIP = TOOLTIP;
const SCORE = _i18n.i18n.translate('xpack.securitySolution.ml.table.scoreTitle', {
  defaultMessage: 'Anomaly score'
});
exports.SCORE = SCORE;
const HOST_NAME = _i18n.i18n.translate('xpack.securitySolution.ml.table.hostNameTitle', {
  defaultMessage: 'Host name'
});
exports.HOST_NAME = HOST_NAME;
const USER_NAME = _i18n.i18n.translate('xpack.securitySolution.ml.table.userNameTitle', {
  defaultMessage: 'User name'
});
exports.USER_NAME = USER_NAME;
const INFLUENCED_BY = _i18n.i18n.translate('xpack.securitySolution.ml.table.influencedByTitle', {
  defaultMessage: 'Influenced by'
});
exports.INFLUENCED_BY = INFLUENCED_BY;
const ENTITY = _i18n.i18n.translate('xpack.securitySolution.ml.table.entityTitle', {
  defaultMessage: 'Entity'
});
exports.ENTITY = ENTITY;
const DETECTOR = _i18n.i18n.translate('xpack.securitySolution.ml.table.detectorTitle', {
  defaultMessage: 'Job'
});
exports.DETECTOR = DETECTOR;
const NETWORK_NAME = _i18n.i18n.translate('xpack.securitySolution.ml.table.networkNameTitle', {
  defaultMessage: 'Network IP'
});
exports.NETWORK_NAME = NETWORK_NAME;
const TIME_STAMP = _i18n.i18n.translate('xpack.securitySolution.ml.table.timestampTitle', {
  defaultMessage: 'Timestamp'
});
exports.TIME_STAMP = TIME_STAMP;
const JOB_ID = _i18n.i18n.translate('xpack.securitySolution.ml.table.jobIdFilter', {
  defaultMessage: 'Job'
});
exports.JOB_ID = JOB_ID;
const INTERVAL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalTooltip', {
  defaultMessage: 'Show only the highest severity anomaly for each interval (such as hour or day) or show all anomalies in the selected time period.'
});
exports.INTERVAL_TOOLTIP = INTERVAL_TOOLTIP;
const INTERVAL = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalLabel', {
  defaultMessage: 'Interval'
});
exports.INTERVAL = INTERVAL;
const INTERVAL_AUTO = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalAutoOption', {
  defaultMessage: 'Auto'
});
exports.INTERVAL_AUTO = INTERVAL_AUTO;
const INTERVAL_HOUR = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalHourOption', {
  defaultMessage: '1 hour'
});
exports.INTERVAL_HOUR = INTERVAL_HOUR;
const INTERVAL_DAY = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalDayOption', {
  defaultMessage: '1 day'
});
exports.INTERVAL_DAY = INTERVAL_DAY;
const INTERVAL_SHOW_ALL = _i18n.i18n.translate('xpack.securitySolution.ml.table.intervalshowAllOption', {
  defaultMessage: 'Show all'
});
exports.INTERVAL_SHOW_ALL = INTERVAL_SHOW_ALL;