"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInterval = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPTIONS = [{
  value: 'auto',
  text: i18n.INTERVAL_AUTO
}, {
  value: 'hour',
  text: i18n.INTERVAL_HOUR
}, {
  value: 'day',
  text: i18n.INTERVAL_DAY
}, {
  value: 'second',
  text: i18n.INTERVAL_SHOW_ALL
}];
const SelectInterval = ({
  interval,
  onChange
}) => {
  const onChangeCb = (0, _react.useCallback)(e => {
    onChange(e.target.value);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "selectInterval",
    prepend: i18n.INTERVAL,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.INTERVAL_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued"
    })),
    options: OPTIONS,
    value: interval,
    onChange: onChangeCb
  });
};
exports.SelectInterval = SelectInterval;