"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = void 0;
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _label_field = require("./label_field");
var _not_available_prompt = require("./not_available_prompt");
var _kibana = require("../../../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryEditorComponent = ({
  node,
  onSave,
  onCancel
}) => {
  var _node$configuration, _node$configuration2, _node$configuration3;
  const isEditMode = node != null;
  const {
    osquery,
    application: {
      capabilities: {
        osquery: osqueryPermissions
      }
    }
  } = (0, _kibana.useKibana)().services;
  const formMethods = (0, _reactHookForm.useForm)({
    defaultValues: {
      label: node === null || node === void 0 ? void 0 : (_node$configuration = node.configuration) === null || _node$configuration === void 0 ? void 0 : _node$configuration.label,
      query: node === null || node === void 0 ? void 0 : (_node$configuration2 = node.configuration) === null || _node$configuration2 === void 0 ? void 0 : _node$configuration2.query,
      ecs_mapping: node === null || node === void 0 ? void 0 : (_node$configuration3 = node.configuration) === null || _node$configuration3 === void 0 ? void 0 : _node$configuration3.ecs_mapping
    }
  });
  const onSubmit = (0, _react.useCallback)(data => {
    onSave(`!{osquery${JSON.stringify((0, _lodash.pickBy)({
      query: data.query,
      label: data.label,
      ecs_mapping: data.ecs_mapping
    }, value => !(0, _lodash.isEmpty)(value)))}}`, {
      block: true
    });
  }, [onSave]);
  const noOsqueryPermissions = (0, _react.useMemo)(() => (!osqueryPermissions.runSavedQueries || !osqueryPermissions.readSavedQueries) && !osqueryPermissions.writeLiveQueries, [osqueryPermissions.readSavedQueries, osqueryPermissions.runSavedQueries, osqueryPermissions.writeLiveQueries]);
  const OsqueryActionForm = (0, _react.useMemo)(() => {
    if (osquery !== null && osquery !== void 0 && osquery.LiveQueryField) {
      const {
        LiveQueryField
      } = osquery;
      return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, formMethods, /*#__PURE__*/_react.default.createElement(_label_field.LabelField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(LiveQueryField, {
        formMethods: formMethods
      }));
    }
    return null;
  }, [formMethods, osquery]);
  if (noOsqueryPermissions) {
    return /*#__PURE__*/_react.default.createElement(_not_available_prompt.OsqueryNotAvailablePrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.editModalTitle",
    defaultMessage: "Edit query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.addModalTitle",
    defaultMessage: "Add query"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, OsqueryActionForm)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel
  }, _i18n.i18n.translate('xpack.securitySolution.markdown.osquery.modalCancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: formMethods.handleSubmit(onSubmit),
    fill: true
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.addModalConfirmButtonLabel",
    defaultMessage: "Add query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.editModalConfirmButtonLabel",
    defaultMessage: "Save changes"
  }))));
};
const OsqueryEditor = /*#__PURE__*/_react.default.memo(OsqueryEditorComponent);
const plugin = {
  name: 'osquery',
  button: {
    label: 'Osquery',
    iconType: 'logoOsquery'
  },
  helpText: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "md",
    fontSize: "l",
    paddingSize: "s",
    isCopyable: true
  }, '!{osquery{options}}'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })),
  editor: OsqueryEditor
};
exports.plugin = plugin;