"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowTopNButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../../helpers");
var _top_n = require("../../top_n");
var _model = require("../../../store/sourcerer/model");
var _sourcerer = require("../../../containers/sourcerer");
var _accessibility = require("../../accessibility");
var _utils = require("../utils");
var _keyboard_shortcut_constants = require("../keyboard_shortcut_constants");
var _helpers2 = require("../../top_n/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.hoverActions.showTopTooltip', {
  values: {
    fieldName
  },
  defaultMessage: `Show top {fieldName}`
});
const ShowTopNButton = /*#__PURE__*/_react.default.memo(({
  className,
  Component,
  enablePopOver,
  field,
  flush,
  iconSide,
  iconType,
  isExpandable,
  onClick,
  onFilterAdded,
  ownFocus,
  paddingSize,
  showLegend,
  showTooltip = true,
  showTopN,
  scopeId,
  title,
  value,
  globalFilters
}) => {
  const activeScope = (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? _model.SourcererScopeName.timeline : scopeId != null && (0, _helpers2.isDetectionsAlertsTable)(scopeId) ? _model.SourcererScopeName.detections : _model.SourcererScopeName.default;
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)(activeScope);
  const icon = iconType !== null && iconType !== void 0 ? iconType : 'visBarVertical';
  const side = iconSide !== null && iconSide !== void 0 ? iconSide : 'left';
  const buttonTitle = title !== null && title !== void 0 ? title : SHOW_TOP(field);
  const basicButton = (0, _react.useMemo)(() => Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": buttonTitle,
    className: className,
    "data-test-subj": "show-top-field",
    icon: icon,
    iconType: icon,
    iconSide: side,
    flush: flush,
    onClick: onClick,
    title: buttonTitle
  }, buttonTitle) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": buttonTitle,
    className: "securitySolution__hoverActionButton",
    "data-test-subj": "show-top-field",
    iconSize: "s",
    iconType: icon,
    onClick: onClick
  }), [Component, buttonTitle, className, flush, icon, onClick, side]);
  const button = (0, _react.useMemo)(() => showTooltip && !showTopN ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_accessibility.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: (0, _utils.getAdditionalScreenReaderOnlyContext)({
        field,
        value
      }),
      content: buttonTitle,
      shortcut: _keyboard_shortcut_constants.SHOW_TOP_N_KEYBOARD_SHORTCUT,
      showShortcut: ownFocus
    })
  }, basicButton) : basicButton, [basicButton, buttonTitle, field, ownFocus, showTooltip, showTopN, value]);
  const topNPannel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_top_n.StatefulTopN, {
    browserFields: browserFields,
    field: field,
    indexPattern: indexPattern,
    onFilterAdded: onFilterAdded,
    paddingSize: paddingSize,
    showLegend: showLegend,
    scopeId: scopeId !== null && scopeId !== void 0 ? scopeId : undefined,
    toggleTopN: onClick,
    globalFilters: globalFilters
  }), [browserFields, field, indexPattern, onFilterAdded, paddingSize, showLegend, scopeId, onClick, globalFilters]);
  if (isExpandable) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, basicButton, showTopN && topNPannel);
  }
  return showTopN ? enablePopOver ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: basicButton,
    isOpen: showTopN,
    closePopover: onClick,
    panelClassName: "withHoverActions__popover",
    "data-test-subj": "showTopNContainer"
  }, topNPannel) : topNPannel : button;
});
exports.ShowTopNButton = ShowTopNButton;
ShowTopNButton.displayName = 'ShowTopNButton';