"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FirstLastSeenType = exports.FirstLastSeen = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_first_last_seen = require("../../containers/use_first_last_seen");
var _empty_value = require("../empty_value");
var _formatted_date = require("../formatted_date");
var _search_strategy = require("../../../../common/search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FirstLastSeenType;
exports.FirstLastSeenType = FirstLastSeenType;
(function (FirstLastSeenType) {
  FirstLastSeenType["FIRST_SEEN"] = "first-seen";
  FirstLastSeenType["LAST_SEEN"] = "last-seen";
})(FirstLastSeenType || (exports.FirstLastSeenType = FirstLastSeenType = {}));
const FirstLastSeen = /*#__PURE__*/_react.default.memo(({
  indexPatterns,
  field,
  type,
  value
}) => {
  const [loading, {
    firstSeen,
    lastSeen,
    errorMessage
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field,
    value,
    order: type === FirstLastSeenType.FIRST_SEEN ? _search_strategy.Direction.asc : _search_strategy.Direction.desc,
    defaultIndex: indexPatterns
  });
  const valueSeen = (0, _react.useMemo)(() => type === FirstLastSeenType.FIRST_SEEN ? firstSeen : lastSeen, [firstSeen, lastSeen, type]);
  if (errorMessage != null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: errorMessage,
      "data-test-subj": "firstLastSeenErrorToolTip",
      "aria-label": `firstLastSeenError-${type}`,
      id: `firstLastSeenError-${field}-${type}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-describedby": `firstLastSeenError-${field}-${type}`,
      type: "warning"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "loading-spinner",
    size: "m"
  }), !loading && valueSeen != null && new Date(valueSeen).toString() === 'Invalid Date' ? valueSeen : !loading && valueSeen !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "first-last-seen-value",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: `${valueSeen}`
  })), !loading && valueSeen === null && (0, _empty_value.getEmptyTagValue)());
});
exports.FirstLastSeen = FirstLastSeen;
FirstLastSeen.displayName = 'FirstLastSeen';