"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewEditMode = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useViewEditMode = ({
  controlGroup,
  initialMode = _public.ViewMode.VIEW
}) => {
  const [filterGroupMode, setFilterGroupMode] = (0, _react.useState)(initialMode);
  const [hasPendingChanges, setHasPendingChanges] = (0, _react.useState)(false);
  const [pendingChangesPopoverOpen, setPendingChangesPopoverOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (controlGroup && controlGroup.getInput().viewMode !== filterGroupMode) {
      controlGroup.updateInput({
        viewMode: filterGroupMode
      });
    }
  }, [controlGroup, filterGroupMode]);
  (0, _react.useEffect)(() => {
    setPendingChangesPopoverOpen(hasPendingChanges);
  }, [hasPendingChanges]);
  const closePendingChangesPopover = (0, _react.useCallback)(() => {
    setPendingChangesPopoverOpen(false);
  }, []);
  const openPendingChangesPopover = (0, _react.useCallback)(() => {
    if (hasPendingChanges) setPendingChangesPopoverOpen(true);
  }, [hasPendingChanges]);
  const switchToEditMode = (0, _react.useCallback)(() => {
    controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.updateInput({
      viewMode: _public.ViewMode.EDIT
    });
    setFilterGroupMode(_public.ViewMode.EDIT);
  }, [controlGroup]);
  const switchToViewMode = (0, _react.useCallback)(() => {
    controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.updateInput({
      viewMode: _public.ViewMode.VIEW
    });
    setHasPendingChanges(false);
    setFilterGroupMode(_public.ViewMode.VIEW);
  }, [controlGroup]);
  const isViewMode = filterGroupMode === _public.ViewMode.VIEW;
  return {
    isViewMode,
    hasPendingChanges,
    pendingChangesPopoverOpen,
    closePendingChangesPopover,
    openPendingChangesPopover,
    switchToEditMode,
    switchToViewMode,
    setHasPendingChanges
  };
};
exports.useViewEditMode = useViewEditMode;