"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitFullScreen = exports.EXIT_FULL_SCREEN_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXIT_FULL_SCREEN_CLASS_NAME = 'exit-full-screen';
exports.EXIT_FULL_SCREEN_CLASS_NAME = EXIT_FULL_SCREEN_CLASS_NAME;
const ExitFullScreenComponent = ({
  fullScreen,
  setFullScreen
}) => {
  const exitFullScreen = (0, _react.useCallback)(() => {
    setFullScreen(false);
  }, [setFullScreen]);
  const onKeyDown = (0, _react.useCallback)(event => {
    if (event.key === 'Escape') {
      event.preventDefault();
      exitFullScreen();
    }
  }, [exitFullScreen]);
  if (!fullScreen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: EXIT_FULL_SCREEN_CLASS_NAME,
    "data-test-subj": "exit-full-screen",
    fullWidth: false,
    iconType: "fullScreen",
    fill: true,
    isDisabled: !fullScreen,
    onClick: exitFullScreen
  }, i18n.EXIT_FULL_SCREEN));
};
ExitFullScreenComponent.displayName = 'ExitFullScreenComponent';
const ExitFullScreen = /*#__PURE__*/_react.default.memo(ExitFullScreenComponent);
exports.ExitFullScreen = ExitFullScreen;