"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProviderContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _helpers = require("../../../timelines/components/timeline/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProviderContainerComponent = _styledComponents.default.div`
  ${({
  isDragging
}) => !isDragging && (0, _styledComponents.css)`
      & {
        border-radius: 2px;
        padding: 0 4px 0 8px;
        position: relative;
        z-index: ${({
  theme
}) => theme.eui.euiZLevel0} !important;

        &::before {
          background-image: linear-gradient(
              135deg,
              ${({
  theme
}) => theme.eui.euiColorMediumShade} 25%,
              transparent 25%
            ),
            linear-gradient(
              -135deg,
              ${({
  theme
}) => theme.eui.euiColorMediumShade} 25%,
              transparent 25%
            ),
            linear-gradient(
              135deg,
              transparent 75%,
              ${({
  theme
}) => theme.eui.euiColorMediumShade} 75%
            ),
            linear-gradient(
              -135deg,
              transparent 75%,
              ${({
  theme
}) => theme.eui.euiColorMediumShade} 75%
            );
          background-position: 0 0, 1px 0, 1px -1px, 0px 1px;
          background-size: 2px 2px;
          bottom: 2px;
          content: '';
          display: block;
          left: 2px;
          position: absolute;
          top: 2px;
          width: 4px;
        }
      }

      &:hover {
        &,
        & .euiBadge,
        & .euiBadge__text {
          cursor: move; /* Fallback for IE11 */
          cursor: grab;
        }
      }

      .${_helpers.STATEFUL_EVENT_CSS_CLASS_NAME}:hover &,
      tr:hover & {
        &::before {
          background-image: linear-gradient(
              135deg,
              ${({
  theme
}) => theme.eui.euiColorDarkShade} 25%,
              transparent 25%
            ),
            linear-gradient(
              -135deg,
              ${({
  theme
}) => theme.eui.euiColorDarkShade} 25%,
              transparent 25%
            ),
            linear-gradient(
              135deg,
              transparent 75%,
              ${({
  theme
}) => theme.eui.euiColorDarkShade} 75%
            ),
            linear-gradient(
              -135deg,
              transparent 75%,
              ${({
  theme
}) => theme.eui.euiColorDarkShade} 75%
            );
        }
      }

      &:hover,
      &:focus,
      .${_helpers.STATEFUL_EVENT_CSS_CLASS_NAME}:hover &:hover,
      .${_helpers.STATEFUL_EVENT_CSS_CLASS_NAME}:focus &:focus,
      tr:hover &:hover,
      tr:hover &:focus {
        background-color: ${({
  theme
}) => theme.eui.euiColorPrimary};

        &,
        & a,
        & a:hover {
          color: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
        }

        &::before {
          background-image: linear-gradient(
              135deg,
              ${({
  theme
}) => theme.eui.euiColorEmptyShade} 25%,
              transparent 25%
            ),
            linear-gradient(
              -135deg,
              ${({
  theme
}) => theme.eui.euiColorEmptyShade} 25%,
              transparent 25%
            ),
            linear-gradient(
              135deg,
              transparent 75%,
              ${({
  theme
}) => theme.eui.euiColorEmptyShade} 75%
            ),
            linear-gradient(
              -135deg,
              transparent 75%,
              ${({
  theme
}) => theme.eui.euiColorEmptyShade} 75%
            );
        }
      }
    `}

  ${({
  isDragging
}) => isDragging && (0, _styledComponents.css)`
      & {
        z-index: 9999 !important;
      }
    `}
`;
ProviderContainerComponent.displayName = 'ProviderContainerComponent';
const ProviderContainer = /*#__PURE__*/_react.default.memo(ProviderContainerComponent);
exports.ProviderContainer = ProviderContainer;
ProviderContainer.displayName = 'ProviderContainer';