"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStyle = exports.disableHoverActions = exports.ProviderContentWrapper = exports.DraggableWrapper = exports.DragEffects = exports.ConditionalPortal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _react = _interopRequireWildcard(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _drag_and_drop = require("../../store/drag_and_drop");
var _constants = require("../../../timelines/components/row_renderers_browser/constants");
var _truncatable_text = require("../truncatable_text");
var _with_hover_actions = require("../with_hover_actions");
var _helpers = require("./helpers");
var _provider_container = require("./provider_container");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_hover_actions = require("../hover_actions/use_hover_actions");
var _draggable_keyboard_wrapper_hook = require("./draggable_keyboard_wrapper_hook");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// As right now, we do not know what we want there, we will keep it as a placeholder
const DragEffects = _styledComponents.default.div``;
exports.DragEffects = DragEffects;
DragEffects.displayName = 'DragEffects';

/**
 * Wraps the `@hello-pangea/dnd` error boundary. See also:
 * https://github.com/atlassian/react-beautiful-dnd/blob/v12.0.0/docs/guides/setup-problem-detection-and-error-recovery.md
 *
 * NOTE: This extends from `PureComponent` because, at the time of this
 * writing, there's no hook equivalent for `componentDidCatch`, per
 * https://reactjs.org/docs/hooks-faq.html#do-hooks-cover-all-use-cases-for-classes
 */
class DragDropErrorBoundary extends _react.default.PureComponent {
  componentDidCatch() {
    this.forceUpdate(); // required for recovery
  }

  render() {
    return this.props.children;
  }
}
const Wrapper = _styledComponents.default.div`
  display: inline-block;
  max-width: 100%;

  [data-rbd-placeholder-context-id] {
    display: none !important;
  }

  ${({
  disabled
}) => disabled && `
    [data-rbd-draggable-id]:hover,
    .euiBadge:hover,
    .euiBadge__text:hover {
      cursor: default;
    }
  `}
`;
Wrapper.displayName = 'Wrapper';
const ProviderContentWrapper = _styledComponents.default.span`
  > span.euiToolTipAnchor {
    display: block; /* allow EuiTooltip content to be truncatable */
  }

  > span.euiToolTipAnchor.eui-textTruncate {
    display: inline-block; /* do not override display when a tooltip is truncated via eui-textTruncate */
  }
`;
exports.ProviderContentWrapper = ProviderContentWrapper;
const disableHoverActions = timelineId => [_securitysolutionDataTable.TableId.rulePreview, _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID].includes(timelineId !== null && timelineId !== void 0 ? timelineId : '');

/**
 * Wraps a draggable component to handle registration / unregistration of the
 * data provider associated with the item being dropped
 */
exports.disableHoverActions = disableHoverActions;
const getStyle = (style, snapshot) => {
  if (!snapshot.isDropAnimating) {
    return style;
  }
  return {
    ...style,
    transitionDuration: '0.00000001s' // cannot be 0, but can be a very short duration
  };
};
exports.getStyle = getStyle;
const DraggableOnWrapperComponent = ({
  dataProvider,
  hideTopN = false,
  onFilterAdded,
  render,
  fieldType = '',
  isAggregatable = false,
  scopeId,
  truncate
}) => {
  const [providerRegistered, setProviderRegistered] = (0, _react.useState)(false);
  const isDisabled = dataProvider.id.includes(`-${_constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID}-`);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    closePopOverTrigger,
    handleClosePopOverTrigger,
    hoverActionsOwnFocus,
    hoverContent,
    keyboardHandlerRef,
    onCloseRequested,
    openPopover,
    onFocus,
    setContainerRef,
    isShowingTopN
  } = (0, _use_hover_actions.useHoverActions)({
    dataProvider,
    hideTopN,
    onFilterAdded,
    render,
    fieldType,
    isAggregatable,
    scopeId,
    truncate
  });
  const registerProvider = (0, _react.useCallback)(() => {
    if (!isDisabled) {
      dispatch(_drag_and_drop.dragAndDropActions.registerProvider({
        provider: dataProvider
      }));
      setProviderRegistered(true);
    }
  }, [isDisabled, dispatch, dataProvider]);
  const unRegisterProvider = (0, _react.useCallback)(() => providerRegistered && dispatch(_drag_and_drop.dragAndDropActions.unRegisterProvider({
    id: dataProvider.id
  })), [providerRegistered, dispatch, dataProvider.id]);
  (0, _react.useEffect)(() => () => {
    unRegisterProvider();
  }, [unRegisterProvider]);
  const RenderClone = (0, _react.useCallback)((provided, snapshot) => /*#__PURE__*/_react.default.createElement(ConditionalPortal, {
    registerProvider: registerProvider
  }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, provided.draggableProps, provided.dragHandleProps, {
    style: getStyle(provided.draggableProps.style, snapshot),
    ref: provided.innerRef,
    "data-test-subj": "providerContainer",
    tabIndex: -1
  }), /*#__PURE__*/_react.default.createElement(ProviderContentWrapper, {
    "data-test-subj": `draggable-content-${dataProvider.queryMatch.field}`
  }, render(dataProvider, provided, snapshot)))), [dataProvider, registerProvider, render]);
  const DraggableContent = (0, _react.useCallback)((provided, snapshot) => /*#__PURE__*/_react.default.createElement(_provider_container.ProviderContainer, (0, _extends2.default)({}, provided.draggableProps, provided.dragHandleProps, {
    ref: e => {
      provided.innerRef(e);
      setContainerRef(e);
    },
    "data-test-subj": "providerContainer",
    isDragging: snapshot.isDragging,
    registerProvider: registerProvider,
    tabIndex: -1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnlyField"
  }, /*#__PURE__*/_react.default.createElement("p", null, dataProvider.queryMatch.field)), truncate && !snapshot.isDragging ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content"
  }, render(dataProvider, provided, snapshot)) : /*#__PURE__*/_react.default.createElement(ProviderContentWrapper, {
    "data-test-subj": `draggable-content-${dataProvider.queryMatch.field}`
  }, render(dataProvider, provided, snapshot)), !snapshot.isDragging && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "draggableKeyboardInstructionsNotDragging"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DRAGGABLE_KEYBOARD_INSTRUCTIONS_NOT_DRAGGING_SCREEN_READER_ONLY))), [dataProvider, registerProvider, render, setContainerRef, truncate]);
  const {
    onBlur,
    onKeyDown
  } = (0, _draggable_keyboard_wrapper_hook.useDraggableKeyboardWrapper)({
    closePopover: handleClosePopOverTrigger,
    draggableId: (0, _helpers.getDraggableId)(dataProvider.id),
    fieldName: dataProvider.queryMatch.field,
    keyboardHandlerRef,
    openPopover
  });
  const DroppableContent = (0, _react.useCallback)(droppableProvided => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: droppableProvided.innerRef
  }, droppableProvided.droppableProps), /*#__PURE__*/_react.default.createElement("div", {
    className: _securitysolutionTGrid.DRAGGABLE_KEYBOARD_WRAPPER_CLASS_NAME,
    "data-test-subj": "draggableWrapperKeyboardHandler",
    onClick: onFocus,
    onBlur: onBlur,
    onKeyDown: onKeyDown,
    ref: keyboardHandlerRef,
    role: "button",
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_dnd.Draggable, {
    draggableId: (0, _helpers.getDraggableId)(dataProvider.id),
    index: 0,
    key: (0, _helpers.getDraggableId)(dataProvider.id),
    isDragDisabled: isDisabled
  }, DraggableContent)), droppableProvided.placeholder), [DraggableContent, dataProvider.id, isDisabled, keyboardHandlerRef, onBlur, onFocus, onKeyDown]);
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": "draggableWrapperDiv",
    disabled: isDisabled
  }, /*#__PURE__*/_react.default.createElement(DragDropErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_dnd.Droppable, {
    isDropDisabled: true,
    droppableId: (0, _helpers.getDroppableId)(dataProvider.id),
    renderClone: RenderClone
  }, DroppableContent))), [DroppableContent, RenderClone, dataProvider.id, isDisabled]);
  const renderContent = (0, _react.useCallback)(() => content, [content]);
  if (isDisabled) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content);
  return /*#__PURE__*/_react.default.createElement(_with_hover_actions.WithHoverActions, {
    alwaysShow: isShowingTopN || hoverActionsOwnFocus,
    closePopOverTrigger: closePopOverTrigger,
    hoverContent: hoverContent,
    onCloseRequested: onCloseRequested,
    render: renderContent
  });
};
const DraggableWrapperComponent = ({
  dataProvider,
  hideTopN = false,
  isDraggable = false,
  onFilterAdded,
  render,
  isAggregatable = false,
  fieldType = '',
  scopeId,
  truncate
}) => {
  const {
    closePopOverTrigger,
    hoverActionsOwnFocus,
    hoverContent,
    onCloseRequested,
    setContainerRef,
    isShowingTopN
  } = (0, _use_hover_actions.useHoverActions)({
    dataProvider,
    hideTopN,
    isDraggable,
    isAggregatable,
    fieldType,
    onFilterAdded,
    render,
    scopeId,
    truncate
  });
  const renderContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement("div", {
    ref: e => {
      setContainerRef(e);
    },
    tabIndex: -1,
    "data-provider-id": (0, _helpers.getDraggableId)(dataProvider.id)
  }, truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "render-truncatable-content"
  }, render(dataProvider, null, {
    isDragging: false,
    isDropAnimating: false,
    isClone: false,
    dropAnimation: null,
    draggingOver: null,
    combineWith: null,
    combineTargetFor: null,
    mode: null
  })) : /*#__PURE__*/_react.default.createElement(ProviderContentWrapper, {
    "data-test-subj": `render-content-${dataProvider.queryMatch.field}`
  }, render(dataProvider, null, {
    isDragging: false,
    isDropAnimating: false,
    isClone: false,
    dropAnimation: null,
    draggingOver: null,
    combineWith: null,
    combineTargetFor: null,
    mode: null
  }))), [dataProvider, render, setContainerRef, truncate]);
  if (!isDraggable) {
    return /*#__PURE__*/_react.default.createElement(_with_hover_actions.WithHoverActions, {
      alwaysShow: isShowingTopN || hoverActionsOwnFocus,
      closePopOverTrigger: closePopOverTrigger,
      hoverContent: disableHoverActions(scopeId) ? undefined : hoverContent,
      onCloseRequested: onCloseRequested,
      render: renderContent
    });
  }
  return /*#__PURE__*/_react.default.createElement(DraggableOnWrapperComponent, {
    dataProvider: dataProvider,
    hideTopN: hideTopN,
    onFilterAdded: onFilterAdded,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    render: render,
    scopeId: scopeId,
    truncate: truncate
  });
};
const DraggableWrapper = /*#__PURE__*/_react.default.memo(DraggableWrapperComponent);
exports.DraggableWrapper = DraggableWrapper;
DraggableWrapper.displayName = 'DraggableWrapper';
/**
 * Conditionally wraps children in an EuiPortal to ensure drag offsets are correct when dragging
 * from containers that have css transforms
 *
 * See: https://github.com/atlassian/react-beautiful-dnd/issues/499
 */

const ConditionalPortal = /*#__PURE__*/_react.default.memo(({
  children,
  registerProvider
}) => {
  (0, _react.useEffect)(() => {
    registerProvider();
  }, [registerProvider]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
exports.ConditionalPortal = ConditionalPortal;
ConditionalPortal.displayName = 'ConditionalPortal';