"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowCheckBox = exports.HeaderCheckBox = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RowCheckBox = ({
  eventId,
  onRowSelected,
  checked,
  ariaRowindex,
  columnValues,
  disabled,
  loadingEventIds
}) => {
  const handleSelectEvent = (0, _react.useCallback)(event => {
    if (!disabled) {
      onRowSelected({
        eventIds: [eventId],
        isSelected: event.currentTarget.checked
      });
    }
  }, [eventId, onRowSelected, disabled]);
  return loadingEventIds.includes(eventId) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "event-loader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": `select-event select-event-${eventId}`,
    id: eventId,
    checked: checked && !disabled,
    disabled: disabled,
    onChange: handleSelectEvent,
    "aria-label": i18n.CHECKBOX_FOR_ROW({
      ariaRowindex,
      columnValues,
      checked
    })
  });
};
exports.RowCheckBox = RowCheckBox;
const HeaderCheckBox = ({
  onSelectAll,
  isSelectAllChecked
}) => {
  const handleSelectPageChange = (0, _react.useCallback)(event => {
    onSelectAll({
      isSelected: event.currentTarget.checked
    });
  }, [onSelectAll]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "select-all-events",
    id: "select-all-events",
    checked: isSelectAllChecked,
    onChange: handleSelectPageChange
  });
};
exports.HeaderCheckBox = HeaderCheckBox;