"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  useDataGridColumnsSecurityCellActions: true,
  SecurityCellActions: true,
  SecurityCellActionsTrigger: true,
  SecurityCellActionType: true
};
Object.defineProperty(exports, "SecurityCellActionType", {
  enumerable: true,
  get: function () {
    return _constants.SecurityCellActionType;
  }
});
exports.SecurityCellActions = void 0;
Object.defineProperty(exports, "SecurityCellActionsTrigger", {
  enumerable: true,
  get: function () {
    return _constants.SecurityCellActionsTrigger;
  }
});
exports.useDataGridColumnsSecurityCellActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cellActions = require("@kbn/cell-actions");
Object.keys(_cellActions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _cellActions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _cellActions[key];
    }
  });
});
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../actions/constants");
var _model = require("../../store/sourcerer/model");
var _use_get_field_spec = require("../../hooks/use_get_field_spec");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// bridge exports for convenience

const useDataGridColumnsSecurityCellActions = _cellActions.useDataGridColumnsCellActions;
exports.useDataGridColumnsSecurityCellActions = useDataGridColumnsSecurityCellActions;
const SecurityCellActions = ({
  sourcererScopeId = _model.SourcererScopeName.default,
  data,
  children,
  ...props
}) => {
  const getFieldSpec = (0, _use_get_field_spec.useGetFieldSpec)(sourcererScopeId);
  // Make a dependency key to prevent unnecessary re-renders when data object is defined inline
  // It is necessary because the data object is an array or an object and useMemo would always re-render
  const dependencyKey = JSON.stringify(data);
  const fieldData = (0, _react.useMemo)(() => (Array.isArray(data) ? data : [data]).map(({
    field,
    value
  }) => ({
    field: getFieldSpec(field),
    value
  })).filter(item => !!item.field),
  // eslint-disable-next-line react-hooks/exhaustive-deps -- Use the dependencyKey to prevent unnecessary re-renders
  [dependencyKey, getFieldSpec]);
  return fieldData.length > 0 ? /*#__PURE__*/_react.default.createElement(_cellActions.CellActions, (0, _extends2.default)({
    data: fieldData
  }, props), children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.SecurityCellActions = SecurityCellActions;