"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/cases-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _right = require("../../flyout/document_details/right");
var _guided_onboarding_tour = require("../../common/components/guided_onboarding_tour");
var _tour_config = require("../../common/components/guided_onboarding_tour/tour_config");
var _timeline = require("../../../common/types/timeline");
var _link_to = require("../../common/components/link_to");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var _timeline2 = require("../../timelines/store/timeline");
var _sourcerer = require("../../common/containers/sourcerer");
var _model = require("../../common/store/sourcerer/model");
var _endpoint_host_isolation_cases_context = require("../../common/components/endpoint/host_isolation/endpoint_host_isolation_cases_context");
var _page_wrapper = require("../../common/components/page_wrapper");
var _routing = require("../../management/common/routing");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _use_insert_timeline = require("../components/use_insert_timeline");
var timelineMarkdownPlugin = _interopRequireWildcard(require("../../common/components/markdown_editor/plugins/timeline"));
var _side_panel = require("../../timelines/components/side_panel");
var _use_fetch_alert_data = require("./use_fetch_alert_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineDetailsPanel = () => {
  const {
    browserFields,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  return /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    entityType: "events",
    isFlyoutView: true,
    runtimeMappings: runtimeMappings,
    scopeId: _timeline.TimelineId.casePage
  });
};
const CaseContainerComponent = () => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    formatUrl: detectionsFormatUrl,
    search: detectionsUrlSearch
  } = (0, _link_to.useFormatUrl)(_constants.SecurityPageName.rules);
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const [isSecurityFlyoutEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const getDetectionsRuleDetailsHref = (0, _react.useCallback)(ruleId => detectionsFormatUrl((0, _link_to.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', detectionsUrlSearch)), [detectionsFormatUrl, detectionsUrlSearch]);
  const showAlertDetails = (0, _react.useCallback)((alertId, index) => {
    if (isSecurityFlyoutEnabled) {
      openFlyout({
        right: {
          id: _right.DocumentDetailsRightPanelKey,
          params: {
            id: alertId,
            indexName: index,
            scopeId: _timeline.TimelineId.casePage
          }
        }
      });
    }
    // TODO remove when https://github.com/elastic/security-team/issues/7462 is merged
    // support of old flyout in cases page
    else {
      dispatch(_timeline2.timelineActions.toggleDetailPanel({
        panelView: 'eventDetail',
        id: _timeline.TimelineId.casePage,
        params: {
          eventId: alertId,
          indexName: index
        }
      }));
    }
  }, [dispatch, isSecurityFlyoutEnabled, openFlyout]);
  const endpointDetailsHref = endpointId => getAppUrl({
    path: (0, _routing.getEndpointDetailsPath)({
      name: 'endpointActivityLog',
      selected_endpoint: endpointId
    })
  });
  // TO-DO: onComponentInitialized not needed after removing the expandedEvent state from timeline
  const onComponentInitialized = (0, _react.useCallback)(() => {
    dispatch(_timeline2.timelineActions.createTimeline({
      id: _timeline.TimelineId.casePage,
      columns: [],
      dataViewId: null,
      indexNames: [],
      expandedDetail: {},
      show: false
    }));
  }, [dispatch]);
  const refreshRef = (0, _react.useRef)(null);
  const {
    activeStep,
    endTourStep,
    isTourShown
  } = (0, _guided_onboarding_tour.useTourContext)();
  const isTourActive = (0, _react.useMemo)(() => activeStep === _tour_config.AlertsCasesTourSteps.viewCase && isTourShown(_tour_config.SecurityStepId.alertsCases), [activeStep, isTourShown]);
  (0, _react.useEffect)(() => {
    if (isTourActive) endTourStep(_tour_config.SecurityStepId.alertsCases);
  }, [endTourStep, isTourActive]);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: true
  }, /*#__PURE__*/_react.default.createElement(_endpoint_host_isolation_cases_context.CaseDetailsRefreshContext.Provider, {
    value: refreshRef
  }, cases.ui.getCases({
    basePath: _constants.CASES_PATH,
    owner: [_constants.APP_ID],
    features: {
      metrics: [_common.CaseMetricsFeature.ALERTS_COUNT, _common.CaseMetricsFeature.ALERTS_USERS, _common.CaseMetricsFeature.ALERTS_HOSTS, _common.CaseMetricsFeature.CONNECTORS, _common.CaseMetricsFeature.LIFESPAN],
      alerts: {
        isExperimental: false
      }
    },
    refreshRef,
    onComponentInitialized,
    actionsNavigation: {
      href: endpointDetailsHref,
      onClick: (endpointId, e) => {
        if (e) {
          e.preventDefault();
        }
        return navigateTo({
          path: (0, _routing.getEndpointDetailsPath)({
            name: 'endpointActivityLog',
            selected_endpoint: endpointId
          })
        });
      }
    },
    ruleDetailsNavigation: {
      href: getDetectionsRuleDetailsHref,
      onClick: async (ruleId, e) => {
        if (e) {
          e.preventDefault();
        }
        return navigateTo({
          deepLinkId: _constants.SecurityPageName.rules,
          path: (0, _link_to.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
        });
      }
    },
    showAlertDetails,
    timelineIntegration: {
      editor_plugins: {
        parsingPlugin: timelineMarkdownPlugin.parser,
        processingPluginRenderer: timelineMarkdownPlugin.renderer,
        uiPlugin: timelineMarkdownPlugin.plugin
      },
      hooks: {
        useInsertTimeline: _use_insert_timeline.useInsertTimeline
      },
      ui: {
        renderTimelineDetailsPanel: TimelineDetailsPanel
      }
    },
    useFetchAlertData: _use_fetch_alert_data.useFetchAlertData,
    permissions: userCasesPermissions
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.case
  }));
};
const Cases = /*#__PURE__*/_react.default.memo(CaseContainerComponent);
exports.Cases = Cases;