"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalKQLHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactReversePortal = require("react-reverse-portal");
var _use_global_header_portal = require("../../../../common/hooks/use_global_header_portal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledStickyWrapper = _styledComponents.default.div`
  position: sticky;
  z-index: ${props => props.theme.eui.euiZHeaderBelowDataGrid};
  top: var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0));
`;
const GlobalKQLHeader = /*#__PURE__*/_react.default.memo(() => {
  const {
    globalKQLHeaderPortalNode
  } = (0, _use_global_header_portal.useGlobalHeaderPortal)();
  return /*#__PURE__*/_react.default.createElement(StyledStickyWrapper, {
    id: "securitySolutionStickyKQL"
  }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: globalKQLHeaderPortalNode
  }));
});
exports.GlobalKQLHeader = GlobalKQLHeader;
GlobalKQLHeader.displayName = 'GlobalKQLHeader';