"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterLensAction = void 0;
var _cellActions = require("@kbn/cell-actions");
var _utils = require("@kbn/cell-actions/src/actions/utils");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _translations = require("@kbn/cell-actions/src/actions/translations");
var _i18n = require("@kbn/i18n");
var _timeline = require("../../../timelines/store/timeline");
var _utils2 = require("../../utils");
var _types = require("../../../../common/types");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isDataColumnsValid(data) {
  return !!data && data.length > 0 && data.every(({
    columnMeta
  }) => columnMeta && (0, _utils2.fieldHasCellActions)(columnMeta.field));
}
const createFilterLensAction = ({
  id,
  order,
  store,
  services,
  negate
}) => {
  const {
    application,
    notifications,
    data: dataService,
    topValuesPopover
  } = services;
  let currentAppId;
  application.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  const getTimelineById = _timeline.timelineSelectors.getTimelineByIdSelector();
  return (0, _public2.createAction)({
    id,
    order,
    getIconType: () => negate ? 'minusInCircle' : 'plusInCircle',
    getDisplayName: () => negate ? _i18n.i18n.translate('xpack.securitySolution.actions.filterOutTimeline', {
      defaultMessage: `Filter out`
    }) : _i18n.i18n.translate('xpack.securitySolution.actions.filterForTimeline', {
      defaultMessage: `Filter for`
    }),
    type: _constants.DefaultCellActionTypes.FILTER,
    isCompatible: async ({
      embeddable,
      data
    }) => !(0, _public.isErrorEmbeddable)(embeddable) && (0, _utils2.isLensEmbeddable)(embeddable) && isDataColumnsValid(data) && (0, _utils2.isInSecurityApp)(currentAppId),
    execute: async ({
      data
    }) => {
      var _data$, _data$$columnMeta, _data$2;
      const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : (_data$$columnMeta = _data$.columnMeta) === null || _data$$columnMeta === void 0 ? void 0 : _data$$columnMeta.field;
      const rawValue = (_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : _data$2.value;
      const value = (0, _utils.filterOutNullableValues)((0, _utils.valueToArray)(rawValue));
      if (!(0, _utils.isValueSupportedByDefaultActions)(value)) {
        notifications.toasts.addWarning({
          title: _translations.ACTION_INCOMPATIBLE_VALUE_WARNING
        });
        return;
      }
      if (!field) return;
      topValuesPopover.closePopover();
      const addFilter = negate === true ? _cellActions.addFilterOut : _cellActions.addFilterIn;
      const timeline = getTimelineById(store.getState(), _types.TimelineId.active);
      // timeline is open add the filter to timeline, otherwise add filter to global filters
      const filterManager = timeline !== null && timeline !== void 0 && timeline.show ? timeline.filterManager : dataService.query.filterManager;
      addFilter({
        filterManager,
        fieldName: field,
        value
      });
    }
  });
};
exports.createFilterLensAction = createFilterLensAction;