"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdFieldEnum = exports.IdField = exports.CreateAssetCriticalityRecord = exports.AssetCriticalityRecordIdParts = exports.AssetCriticalityRecord = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const IdField = _zod.z.enum(['host.name', 'user.name']);
exports.IdField = IdField;
const IdFieldEnum = IdField.enum;
exports.IdFieldEnum = IdFieldEnum;
const AssetCriticalityRecordIdParts = _zod.z.object({
  /**
   * The ID value of the asset.
   */
  id_value: _zod.z.string(),
  /**
   * The field representing the ID.
   */
  id_field: IdField
});
exports.AssetCriticalityRecordIdParts = AssetCriticalityRecordIdParts;
const CreateAssetCriticalityRecord = AssetCriticalityRecordIdParts.merge(_zod.z.object({
  /**
   * The criticality level of the asset.
   */
  criticality_level: _zod.z.enum(['very_important', 'important', 'normal', 'not_important'])
}));
exports.CreateAssetCriticalityRecord = CreateAssetCriticalityRecord;
const AssetCriticalityRecord = CreateAssetCriticalityRecord.merge(_zod.z.object({
  /**
   * The time the record was created or updated.
   */
  '@timestamp': _zod.z.string().datetime()
}));
exports.AssetCriticalityRecord = AssetCriticalityRecord;