"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionFileInfoSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Schema that validates the file info API */
const EndpointActionFileInfoSchema = {
  params: _configSchema.schema.object({
    action_id: _configSchema.schema.string({
      minLength: 1
    }),
    file_id: _configSchema.schema.string({
      minLength: 1
    })
  })
};
exports.EndpointActionFileInfoSchema = EndpointActionFileInfoSchema;