"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionStatusOrder = exports.RuleExecutionStatusEnum = exports.RuleExecutionStatus = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

/**
  * Custom execution status of Security rules that is different from the status used in the Alerting Framework. We merge our custom status with the Framework's status to determine the resulting status of a rule.
- going to run - @deprecated Replaced by the 'running' status but left for backwards compatibility with rule execution events already written to Event Log in the prior versions of Kibana. Don't use when writing rule status changes.
- running - Rule execution started but not reached any intermediate or final status.
- partial failure - Rule can partially fail for various reasons either in the middle of an execution (in this case we update its status right away) or in the end of it. So currently this status can be both intermediate and final at the same time. A typical reason for a partial failure: not all the indices that the rule searches over actually exist.
- failed - Rule failed to execute due to unhandled exception or a reason defined in the business logic of its executor function.
- succeeded - Rule executed successfully without any issues. Note: this status is just an indication of a rule's "health". The rule might or might not generate any alerts despite of it.
  */

const RuleExecutionStatus = _zod.z.enum(['going to run', 'running', 'partial failure', 'failed', 'succeeded']);
exports.RuleExecutionStatus = RuleExecutionStatus;
const RuleExecutionStatusEnum = RuleExecutionStatus.enum;
exports.RuleExecutionStatusEnum = RuleExecutionStatusEnum;
const RuleExecutionStatusOrder = _zod.z.number().int();
exports.RuleExecutionStatusOrder = RuleExecutionStatusOrder;