"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingVersion = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A symbol that represents a missing value and used when a base version of a
 * rule is not available. We need a mechanism that helps us distinguish two
 * situations:
 * - the base version is found, and its value is `undefined` or `null`
 * - the base version is not found
 *
 */
const MissingVersion = Symbol('MissingVersion');

/**
 * Three versions of a value to pass to a diff algorithm.
 */

/**
 * Represents a result of an abstract three-way diff/merge operation on a value
 * (could be a whole rule JSON or a given rule field).
 *
 * Typical situations:
 *
 * 1. base=A, current=A, target=A => merged=A, conflict=false
 *    Stock rule, the value hasn't changed.
 *
 * 2. base=A, current=A, target=B => merged=B, conflict=false
 *    Stock rule, the value has changed.
 *
 * 3. base=A, current=B, target=A => merged=B, conflict=false
 *    Customized rule, the value hasn't changed.
 *
 * 4. base=A, current=B, target=B => merged=B, conflict=false
 *    Customized rule, the value has changed exactly the same way as in the user customization.
 *
 * 5. base=A, current=B, target=C => merged=D, conflict=false
 *    Customized rule, the value has changed, conflict between B and C resolved automatically.
 *
 * 6. base=A, current=B, target=C => merged=C, conflict=true
 *    Customized rule, the value has changed, conflict between B and C couldn't be resolved automatically.
 */

/**
 * Given the three versions of a value, calculates a three-way diff for it.
 */
exports.MissingVersion = MissingVersion;