"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UUID = exports.TimestampOverrideFallbackDisabled = exports.TimestampOverride = exports.TimelineTemplateTitle = exports.TimelineTemplateId = exports.ThreatTechnique = exports.ThreatTactic = exports.ThreatSubtechnique = exports.ThreatArray = exports.Threat = exports.SeverityMapping = exports.SeverityEnum = exports.Severity = exports.SetupGuide = exports.SavedQueryId = exports.SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcome = exports.SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurpose = exports.RuleVersion = exports.RuleTagArray = exports.RuleSignatureId = exports.RuleReferenceArray = exports.RuleQuery = exports.RuleObjectId = exports.RuleNameOverride = exports.RuleName = exports.RuleMetadata = exports.RuleLicense = exports.RuleIntervalTo = exports.RuleIntervalFrom = exports.RuleInterval = exports.RuleFilterArray = exports.RuleFalsePositiveArray = exports.RuleExceptionList = exports.RuleDescription = exports.RuleAuthorArray = exports.RuleActionThrottle = exports.RuleActionParams = exports.RuleActionNotifyWhenEnum = exports.RuleActionNotifyWhen = exports.RuleActionId = exports.RuleActionGroup = exports.RuleActionFrequency = exports.RuleActionAlertsFilter = exports.RuleAction = exports.RiskScoreMapping = exports.RiskScore = exports.RequiredFieldArray = exports.RequiredField = exports.RelatedIntegrationArray = exports.RelatedIntegration = exports.QueryLanguageEnum = exports.QueryLanguage = exports.NonEmptyString = exports.MaxSignals = exports.KqlQueryLanguageEnum = exports.KqlQueryLanguage = exports.IsRuleImmutable = exports.IsRuleEnabled = exports.InvestigationGuide = exports.InvestigationFields = exports.IndexPatternArray = exports.ExceptionListTypeEnum = exports.ExceptionListType = exports.DataViewId = exports.BuildingBlockType = exports.AlertsIndexNamespace = exports.AlertsIndex = exports.AlertSuppressionDuration = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

/**
 * A string that is not empty and does not contain only whitespace
 */

const NonEmptyString = _zod.z.string().min(1).regex(/^(?! *$).+$/);

/**
 * A universally unique identifier
 */
exports.NonEmptyString = NonEmptyString;
const UUID = _zod.z.string().uuid();
exports.UUID = UUID;
const RuleObjectId = UUID;

/**
 * Could be any string, not necessarily a UUID
 */
exports.RuleObjectId = RuleObjectId;
const RuleSignatureId = _zod.z.string();
exports.RuleSignatureId = RuleSignatureId;
const RuleName = _zod.z.string().min(1);
exports.RuleName = RuleName;
const RuleDescription = _zod.z.string().min(1);

/**
 * The rule's version number.
 */
exports.RuleDescription = RuleDescription;
const RuleVersion = _zod.z.number().int().min(1);
exports.RuleVersion = RuleVersion;
const QueryLanguage = _zod.z.enum(['kuery', 'lucene', 'eql', 'esql']);
exports.QueryLanguage = QueryLanguage;
const QueryLanguageEnum = QueryLanguage.enum;
exports.QueryLanguageEnum = QueryLanguageEnum;
const KqlQueryLanguage = _zod.z.enum(['kuery', 'lucene']);
exports.KqlQueryLanguage = KqlQueryLanguage;
const KqlQueryLanguageEnum = KqlQueryLanguage.enum;
exports.KqlQueryLanguageEnum = KqlQueryLanguageEnum;
const IsRuleImmutable = _zod.z.boolean();

/**
 * Determines whether the rule is enabled.
 */
exports.IsRuleImmutable = IsRuleImmutable;
const IsRuleEnabled = _zod.z.boolean();

/**
 * Frequency of rule execution, using a date math range. For example, "1h" means the rule runs every hour. Defaults to 5m (5 minutes).
 */
exports.IsRuleEnabled = IsRuleEnabled;
const RuleInterval = _zod.z.string();

/**
 * Time from which data is analyzed each time the rule executes, using a date math range. For example, now-4200s means the rule analyzes data from 70 minutes before its start time. Defaults to now-6m (analyzes data from 6 minutes before the start time).
 */
exports.RuleInterval = RuleInterval;
const RuleIntervalFrom = _zod.z.string().superRefine(_zodHelpers.isValidDateMath);
exports.RuleIntervalFrom = RuleIntervalFrom;
const RuleIntervalTo = _zod.z.string();

/**
 * Risk score (0 to 100)
 */
exports.RuleIntervalTo = RuleIntervalTo;
const RiskScore = _zod.z.number().int().min(0).max(100);

/**
 * Overrides generated alerts' risk_score with a value from the source event
 */
exports.RiskScore = RiskScore;
const RiskScoreMapping = _zod.z.array(_zod.z.object({
  field: _zod.z.string(),
  operator: _zod.z.literal('equals'),
  value: _zod.z.string(),
  risk_score: RiskScore.optional()
}));

/**
 * Severity of the rule
 */
exports.RiskScoreMapping = RiskScoreMapping;
const Severity = _zod.z.enum(['low', 'medium', 'high', 'critical']);
exports.Severity = Severity;
const SeverityEnum = Severity.enum;

/**
 * Overrides generated alerts' severity with values from the source event
 */
exports.SeverityEnum = SeverityEnum;
const SeverityMapping = _zod.z.array(_zod.z.object({
  field: _zod.z.string(),
  operator: _zod.z.literal('equals'),
  severity: Severity,
  value: _zod.z.string()
}));

/**
 * String array containing words and phrases to help categorize, filter, and search rules. Defaults to an empty array.
 */
exports.SeverityMapping = SeverityMapping;
const RuleTagArray = _zod.z.array(_zod.z.string());
exports.RuleTagArray = RuleTagArray;
const RuleMetadata = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The rule's license.
 */
exports.RuleMetadata = RuleMetadata;
const RuleLicense = _zod.z.string();
exports.RuleLicense = RuleLicense;
const RuleAuthorArray = _zod.z.array(_zod.z.string());
exports.RuleAuthorArray = RuleAuthorArray;
const RuleFalsePositiveArray = _zod.z.array(_zod.z.string());
exports.RuleFalsePositiveArray = RuleFalsePositiveArray;
const RuleReferenceArray = _zod.z.array(_zod.z.string());

/**
 * Notes to help investigate alerts produced by the rule.
 */
exports.RuleReferenceArray = RuleReferenceArray;
const InvestigationGuide = _zod.z.string();
exports.InvestigationGuide = InvestigationGuide;
const SetupGuide = _zod.z.string();

/**
 * Determines if the rule acts as a building block. By default, building-block alerts are not displayed in the UI. These rules are used as a foundation for other rules that do generate alerts. Its value must be default.
 */
exports.SetupGuide = SetupGuide;
const BuildingBlockType = _zod.z.string();

/**
 * (deprecated) Has no effect.
 */
exports.BuildingBlockType = BuildingBlockType;
const AlertsIndex = _zod.z.string();

/**
 * Has no effect.
 */
exports.AlertsIndex = AlertsIndex;
const AlertsIndexNamespace = _zod.z.string();
exports.AlertsIndexNamespace = AlertsIndexNamespace;
const MaxSignals = _zod.z.number().int().min(1);
exports.MaxSignals = MaxSignals;
const ThreatSubtechnique = _zod.z.object({
  /**
   * Subtechnique ID
   */
  id: _zod.z.string(),
  /**
   * Subtechnique name
   */
  name: _zod.z.string(),
  /**
   * Subtechnique reference
   */
  reference: _zod.z.string()
});
exports.ThreatSubtechnique = ThreatSubtechnique;
const ThreatTechnique = _zod.z.object({
  /**
   * Technique ID
   */
  id: _zod.z.string(),
  /**
   * Technique name
   */
  name: _zod.z.string(),
  /**
   * Technique reference
   */
  reference: _zod.z.string(),
  /**
   * Array containing more specific information on the attack technique
   */
  subtechnique: _zod.z.array(ThreatSubtechnique).optional()
});
exports.ThreatTechnique = ThreatTechnique;
const ThreatTactic = _zod.z.object({
  /**
   * Tactic ID
   */
  id: _zod.z.string(),
  /**
   * Tactic name
   */
  name: _zod.z.string(),
  /**
   * Tactic reference
   */
  reference: _zod.z.string()
});
exports.ThreatTactic = ThreatTactic;
const Threat = _zod.z.object({
  /**
   * Relevant attack framework
   */
  framework: _zod.z.string(),
  tactic: ThreatTactic,
  /**
   * Array containing information on the attack techniques (optional)
   */
  technique: _zod.z.array(ThreatTechnique).optional()
});
exports.Threat = Threat;
const ThreatArray = _zod.z.array(Threat);
exports.ThreatArray = ThreatArray;
const IndexPatternArray = _zod.z.array(_zod.z.string());
exports.IndexPatternArray = IndexPatternArray;
const DataViewId = _zod.z.string();
exports.DataViewId = DataViewId;
const SavedQueryId = _zod.z.string();
exports.SavedQueryId = SavedQueryId;
const RuleQuery = _zod.z.string();
exports.RuleQuery = RuleQuery;
const RuleFilterArray = _zod.z.array(_zod.z.unknown());

/**
 * Sets the source field for the alert's signal.rule.name value
 */
exports.RuleFilterArray = RuleFilterArray;
const RuleNameOverride = _zod.z.string();

/**
 * Sets the time field used to query indices
 */
exports.RuleNameOverride = RuleNameOverride;
const TimestampOverride = _zod.z.string();

/**
 * Disables the fallback to the event's @timestamp field
 */
exports.TimestampOverride = TimestampOverride;
const TimestampOverrideFallbackDisabled = _zod.z.boolean();
exports.TimestampOverrideFallbackDisabled = TimestampOverrideFallbackDisabled;
const RequiredField = _zod.z.object({
  name: NonEmptyString,
  type: NonEmptyString,
  ecs: _zod.z.boolean()
});
exports.RequiredField = RequiredField;
const RequiredFieldArray = _zod.z.array(RequiredField);

/**
 * Timeline template ID
 */
exports.RequiredFieldArray = RequiredFieldArray;
const TimelineTemplateId = _zod.z.string();

/**
 * Timeline template title
 */
exports.TimelineTemplateId = TimelineTemplateId;
const TimelineTemplateTitle = _zod.z.string();
exports.TimelineTemplateTitle = TimelineTemplateTitle;
const SavedObjectResolveOutcome = _zod.z.enum(['exactMatch', 'aliasMatch', 'conflict']);
exports.SavedObjectResolveOutcome = SavedObjectResolveOutcome;
const SavedObjectResolveOutcomeEnum = SavedObjectResolveOutcome.enum;
exports.SavedObjectResolveOutcomeEnum = SavedObjectResolveOutcomeEnum;
const SavedObjectResolveAliasTargetId = _zod.z.string();
exports.SavedObjectResolveAliasTargetId = SavedObjectResolveAliasTargetId;
const SavedObjectResolveAliasPurpose = _zod.z.enum(['savedObjectConversion', 'savedObjectImport']);
exports.SavedObjectResolveAliasPurpose = SavedObjectResolveAliasPurpose;
const SavedObjectResolveAliasPurposeEnum = SavedObjectResolveAliasPurpose.enum;
exports.SavedObjectResolveAliasPurposeEnum = SavedObjectResolveAliasPurposeEnum;
const RelatedIntegration = _zod.z.object({
  package: NonEmptyString,
  version: NonEmptyString,
  integration: NonEmptyString.optional()
});
exports.RelatedIntegration = RelatedIntegration;
const RelatedIntegrationArray = _zod.z.array(RelatedIntegration);
exports.RelatedIntegrationArray = RelatedIntegrationArray;
const InvestigationFields = _zod.z.object({
  field_names: _zod.z.array(NonEmptyString).min(1)
});

/**
 * Defines the interval on which a rule's actions are executed.
 */
exports.InvestigationFields = InvestigationFields;
const RuleActionThrottle = _zod.z.union([_zod.z.enum(['no_actions', 'rule']), _zod.z.string().regex(/^[1-9]\d*[smhd]$/)]);

/**
 * The condition for throttling the notification: `onActionGroupChange`, `onActiveAlert`,  or `onThrottleInterval`
 */
exports.RuleActionThrottle = RuleActionThrottle;
const RuleActionNotifyWhen = _zod.z.enum(['onActiveAlert', 'onThrottleInterval', 'onActionGroupChange']);
exports.RuleActionNotifyWhen = RuleActionNotifyWhen;
const RuleActionNotifyWhenEnum = RuleActionNotifyWhen.enum;

/**
 * The action frequency defines when the action runs (for example, only on rule execution or at specific time intervals).
 */
exports.RuleActionNotifyWhenEnum = RuleActionNotifyWhenEnum;
const RuleActionFrequency = _zod.z.object({
  /**
   * Action summary indicates whether we will send a summary notification about all the generate alerts or notification per individual alert
   */
  summary: _zod.z.boolean(),
  notifyWhen: RuleActionNotifyWhen,
  throttle: RuleActionThrottle.nullable()
});
exports.RuleActionFrequency = RuleActionFrequency;
const RuleActionAlertsFilter = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Object containing the allowed connector fields, which varies according to the connector type.
 */
exports.RuleActionAlertsFilter = RuleActionAlertsFilter;
const RuleActionParams = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Optionally groups actions by use cases. Use `default` for alert notifications.
 */
exports.RuleActionParams = RuleActionParams;
const RuleActionGroup = _zod.z.string();

/**
 * The connector ID.
 */
exports.RuleActionGroup = RuleActionGroup;
const RuleActionId = _zod.z.string();
exports.RuleActionId = RuleActionId;
const RuleAction = _zod.z.object({
  /**
   * The action type used for sending notifications.
   */
  action_type_id: _zod.z.string(),
  group: RuleActionGroup,
  id: RuleActionId,
  params: RuleActionParams,
  uuid: NonEmptyString.optional(),
  alerts_filter: RuleActionAlertsFilter.optional(),
  frequency: RuleActionFrequency.optional()
});

/**
 * The exception type
 */
exports.RuleAction = RuleAction;
const ExceptionListType = _zod.z.enum(['detection', 'rule_default', 'endpoint', 'endpoint_trusted_apps', 'endpoint_events', 'endpoint_host_isolation_exceptions', 'endpoint_blocklists']);
exports.ExceptionListType = ExceptionListType;
const ExceptionListTypeEnum = ExceptionListType.enum;
exports.ExceptionListTypeEnum = ExceptionListTypeEnum;
const RuleExceptionList = _zod.z.object({
  /**
   * ID of the exception container
   */
  id: NonEmptyString,
  /**
   * List ID of the exception container
   */
  list_id: NonEmptyString,
  type: ExceptionListType,
  /**
   * Determines the exceptions validity in rule's Kibana space
   */
  namespace_type: _zod.z.enum(['agnostic', 'single'])
});
exports.RuleExceptionList = RuleExceptionList;
const AlertSuppressionDuration = _zod.z.object({
  value: _zod.z.number().int().min(1),
  unit: _zod.z.enum(['s', 'm', 'h'])
});
exports.AlertSuppressionDuration = AlertSuppressionDuration;