"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksIconsCategoriesGroups = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _landing_links = require("./landing_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stackManagementButtonClassName = 'stackManagementSection__button';
const useStyle = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const accordionFontSize = (0, _eui.useEuiFontSize)('xs');
  return {
    accordionButton: (0, _react2.css)`
  .${stackManagementButtonClassName} {
    font-weight: ${euiTheme.font.weight.bold};
    ${accordionFontSize}
  }}
`
  };
};
const LandingLinksIconsCategoriesGroups = /*#__PURE__*/_react.default.memo(function LandingLinksIconsCategoriesGroups({
  links,
  categories: accordionCategories,
  urlState,
  onLinkClick
}) {
  const style = useStyle();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordionCategories.map(({
    label,
    categories
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    key: `${label}_${index}`,
    id: `landingLinksCategoryGroups_${label}_${index}`,
    buttonContent: label,
    buttonClassName: stackManagementButtonClassName,
    css: style.accordionButton
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s"
  }, categories && /*#__PURE__*/_react.default.createElement(LandingLinksIconsCategoryGroups, {
    links: links,
    categories: categories,
    urlState: urlState,
    onLinkClick: onLinkClick
  })))));
});
exports.LandingLinksIconsCategoriesGroups = LandingLinksIconsCategoriesGroups;
const useGroupStyles = () => {
  return {
    container: (0, _react2.css)`
      min-width: 22em;
    `
  };
};
const LandingLinksIconsCategoryGroups = /*#__PURE__*/_react.default.memo(function LandingLinksIconsCategoryGroups({
  links,
  categories,
  urlState,
  onLinkClick
}) {
  const styles = useGroupStyles();
  const categoriesLinks = (0, _react.useMemo)(() => {
    const linksById = Object.fromEntries(links.map(link => [link.id, link]));
    return categories.reduce((acc, {
      label,
      linkIds,
      type,
      iconType
    }) => {
      const linksItem = linkIds.reduce((linksAcc, linkId) => {
        if (linksById[linkId]) {
          linksAcc.push(linksById[linkId]);
        }
        return linksAcc;
      }, []);
      if (linksItem.length > 0) {
        acc.push({
          type,
          label,
          iconType,
          links: linksItem
        });
      }
      return acc;
    }, []);
  }, [links, categories]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xl",
    alignItems: "flexStart",
    wrap: true
  }, categoriesLinks.map(({
    label,
    links: categoryLinks,
    iconType
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${index}_${label}`,
    css: styles.container,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(LandingColumnHeading, {
    label: label,
    iconType: iconType
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingColumnLinks, {
    items: categoryLinks,
    urlState: urlState,
    onLinkClick: onLinkClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }))));
});
const LandingColumnHeading = /*#__PURE__*/_react.default.memo(function LandingColumnHeading({
  label,
  iconType
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, iconType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, label))));
});

// eslint-disable-next-line import/no-default-export
var _default = LandingLinksIconsCategoriesGroups;
exports.default = _default;