"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksIconsCategories = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _landing_links_icons = require("./landing_links_icons");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    horizontalRule: (0, _react2.css)`
      margin-top: ${euiTheme.size.m};
      margin-bottom: ${euiTheme.size.l};
    `
  };
};
const LandingLinksIconsCategories = /*#__PURE__*/_react.default.memo(function LandingLinksIconsCategories({
  links,
  categories,
  urlState,
  onLinkClick
}) {
  const categoriesLinks = (0, _react.useMemo)(() => {
    const linksById = Object.fromEntries(links.map(link => [link.id, link]));
    return categories.reduce((acc, {
      label,
      linkIds,
      type
    }) => {
      const linksItem = linkIds === null || linkIds === void 0 ? void 0 : linkIds.reduce((linksAcc, linkId) => {
        if (linksById[linkId]) {
          linksAcc.push(linksById[linkId]);
        }
        return linksAcc;
      }, []);
      if (linksItem !== null && linksItem !== void 0 && linksItem.length) {
        acc.push({
          type,
          label,
          links: linksItem
        });
      }
      return acc;
    }, []);
  }, [links, categories]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, categoriesLinks.map(({
    type = _constants.LinkCategoryType.title,
    label,
    links: categoryLinks
  }, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: `${index}_${label}`
  }, /*#__PURE__*/_react.default.createElement(CategoryHeading, {
    type: type,
    label: label,
    index: index
  }), /*#__PURE__*/_react.default.createElement(_landing_links_icons.LandingLinksIcons, {
    items: categoryLinks,
    urlState: urlState,
    onLinkClick: onLinkClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }))));
});
exports.LandingLinksIconsCategories = LandingLinksIconsCategories;
const CategoryHeading = /*#__PURE__*/_react.default.memo(function CategoryHeading({
  type,
  label,
  index
}) {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), type === _constants.LinkCategoryType.title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: styles.horizontalRule
  })), type === _constants.LinkCategoryType.separator && index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: styles.horizontalRule
  }));
});

// eslint-disable-next-line import/no-default-export
var _default = LandingLinksIconsCategories;
exports.default = _default;