"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySubFeatureId = exports.CasesSubFeatureId = exports.AssistantSubFeatureId = exports.AppFeatureSecurityKey = exports.AppFeatureKey = exports.AppFeatureCasesKey = exports.AppFeatureAssistantKey = exports.ALL_APP_FEATURE_KEYS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AppFeatureSecurityKey;
exports.AppFeatureSecurityKey = AppFeatureSecurityKey;
(function (AppFeatureSecurityKey) {
  AppFeatureSecurityKey["advancedInsights"] = "advanced_insights";
  AppFeatureSecurityKey["investigationGuide"] = "investigation_guide";
  AppFeatureSecurityKey["endpointHostManagement"] = "endpoint_host_management";
  AppFeatureSecurityKey["endpointPolicyManagement"] = "endpoint_policy_management";
  AppFeatureSecurityKey["endpointPolicyProtections"] = "endpoint_policy_protections";
  AppFeatureSecurityKey["endpointArtifactManagement"] = "endpoint_artifact_management";
  AppFeatureSecurityKey["endpointResponseActions"] = "endpoint_response_actions";
  AppFeatureSecurityKey["threatIntelligence"] = "threat-intelligence";
  AppFeatureSecurityKey["osqueryAutomatedResponseActions"] = "osquery_automated_response_actions";
  AppFeatureSecurityKey["endpointExceptions"] = "endpointExceptions";
  AppFeatureSecurityKey["externalRuleActions"] = "external_rule_actions";
})(AppFeatureSecurityKey || (exports.AppFeatureSecurityKey = AppFeatureSecurityKey = {}));
let AppFeatureCasesKey;
exports.AppFeatureCasesKey = AppFeatureCasesKey;
(function (AppFeatureCasesKey) {
  AppFeatureCasesKey["casesConnectors"] = "cases_connectors";
})(AppFeatureCasesKey || (exports.AppFeatureCasesKey = AppFeatureCasesKey = {}));
let AppFeatureAssistantKey; // Merges the two enums.
exports.AppFeatureAssistantKey = AppFeatureAssistantKey;
(function (AppFeatureAssistantKey) {
  AppFeatureAssistantKey["assistant"] = "assistant";
})(AppFeatureAssistantKey || (exports.AppFeatureAssistantKey = AppFeatureAssistantKey = {}));
const AppFeatureKey = {
  ...AppFeatureSecurityKey,
  ...AppFeatureCasesKey,
  ...AppFeatureAssistantKey
};
// We need to merge the value and the type and export both to replicate how enum works.
exports.AppFeatureKey = AppFeatureKey;
const ALL_APP_FEATURE_KEYS = Object.freeze(Object.values(AppFeatureKey));

/** Sub-features IDs for Security */
exports.ALL_APP_FEATURE_KEYS = ALL_APP_FEATURE_KEYS;
let SecuritySubFeatureId;
/** Sub-features IDs for Cases */
exports.SecuritySubFeatureId = SecuritySubFeatureId;
(function (SecuritySubFeatureId) {
  SecuritySubFeatureId["endpointList"] = "endpointListSubFeature";
  SecuritySubFeatureId["endpointExceptions"] = "endpointExceptionsSubFeature";
  SecuritySubFeatureId["trustedApplications"] = "trustedApplicationsSubFeature";
  SecuritySubFeatureId["hostIsolationExceptions"] = "hostIsolationExceptionsSubFeature";
  SecuritySubFeatureId["blocklist"] = "blocklistSubFeature";
  SecuritySubFeatureId["eventFilters"] = "eventFiltersSubFeature";
  SecuritySubFeatureId["policyManagement"] = "policyManagementSubFeature";
  SecuritySubFeatureId["responseActionsHistory"] = "responseActionsHistorySubFeature";
  SecuritySubFeatureId["hostIsolation"] = "hostIsolationSubFeature";
  SecuritySubFeatureId["processOperations"] = "processOperationsSubFeature";
  SecuritySubFeatureId["fileOperations"] = "fileOperationsSubFeature";
  SecuritySubFeatureId["executeAction"] = "executeActionSubFeature";
})(SecuritySubFeatureId || (exports.SecuritySubFeatureId = SecuritySubFeatureId = {}));
let CasesSubFeatureId;
/** Sub-features IDs for Security Assistant */
exports.CasesSubFeatureId = CasesSubFeatureId;
(function (CasesSubFeatureId) {
  CasesSubFeatureId["deleteCases"] = "deleteCasesSubFeature";
  CasesSubFeatureId["casesSettings"] = "casesSettingsSubFeature";
})(CasesSubFeatureId || (exports.CasesSubFeatureId = CasesSubFeatureId = {}));
let AssistantSubFeatureId;
exports.AssistantSubFeatureId = AssistantSubFeatureId;
(function (AssistantSubFeatureId) {
  AssistantSubFeatureId["createConversation"] = "createConversationSubFeature";
})(AssistantSubFeatureId || (exports.AssistantSubFeatureId = AssistantSubFeatureId = {}));