"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _analytics = require("./analytics");
var _anonymous_access = require("./anonymous_access");
var _api_keys = require("./api_keys");
var _authentication = require("./authentication");
var _authorization = require("./authorization");
var _deprecations = require("./deprecations");
var _indices = require("./indices");
var _role_mapping = require("./role_mapping");
var _security_checkup = require("./security_checkup");
var _session_management = require("./session_management");
var _user_profile = require("./user_profile");
var _users = require("./users");
var _views = require("./views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Describes parameters used to define HTTP routes.
 */

function defineRoutes(params) {
  (0, _analytics.defineAnalyticsRoutes)(params);
  (0, _api_keys.defineApiKeysRoutes)(params);
  (0, _authentication.defineAuthenticationRoutes)(params);
  (0, _authorization.defineAuthorizationRoutes)(params);
  (0, _session_management.defineSessionManagementRoutes)(params);
  (0, _user_profile.defineUserProfileRoutes)(params);
  (0, _users.defineUsersRoutes)(params); // Temporarily allow user APIs (ToDo: move to non-serverless block below)
  (0, _views.defineViewRoutes)(params);

  // In the serverless environment...
  if (params.buildFlavor !== 'serverless') {
    (0, _anonymous_access.defineAnonymousAccessRoutes)(params); // anonymous access is disabled
    (0, _deprecations.defineDeprecationsRoutes)(params); // deprecated kibana user roles are not applicable, these HTTP APIs are not needed
    (0, _indices.defineIndicesRoutes)(params); // the ES privileges form used to help define roles (only consumer) is disabled, so there is no need for these HTTP APIs
    (0, _role_mapping.defineRoleMappingRoutes)(params); // role mappings are managed internally, based on configurations in control plane, these HTTP APIs are not needed
    (0, _security_checkup.defineSecurityCheckupGetStateRoutes)(params); // security checkup is not applicable, these HTTP APIs are not needed
    // defineUsersRoutes(params); // the native realm is not enabled (there is only Elastic cloud SAML), no user HTTP API routes are needed
  }
}