"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceColumnHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _privilege_utils = require("../../../privilege_utils");
var _spaces_popover_list = require("../../../spaces_popover_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPACES_DISPLAY_COUNT = 4;
const SpaceColumnHeader = props => {
  const {
    spacesApiUi
  } = props;
  const isGlobal = (0, _privilege_utils.isGlobalPrivilegeDefinition)(props.entry);
  const entrySpaces = props.entry.spaces.map(spaceId => {
    var _props$spaces$find;
    return (_props$spaces$find = props.spaces.find(s => s.id === spaceId)) !== null && _props$spaces$find !== void 0 ? _props$spaces$find : {
      id: spaceId,
      name: spaceId,
      disabledFeatures: []
    };
  });
  const LazySpaceAvatar = (0, _react.useMemo)(() => spacesApiUi.components.getSpaceAvatar, [spacesApiUi]);
  return /*#__PURE__*/_react.default.createElement("div", null, entrySpaces.slice(0, SPACES_DISPLAY_COUNT).map(space => {
    return /*#__PURE__*/_react.default.createElement("span", {
      key: space.id
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      size: "s",
      space: space
    }), ' ', isGlobal && /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeMatrix.globalSpaceName",
      defaultMessage: "All Spaces"
    })));
  }), entrySpaces.length > SPACES_DISPLAY_COUNT && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_spaces_popover_list.SpacesPopoverList, {
    spaces: entrySpaces,
    buttonText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeMatrix.showNMoreSpacesLink', {
      defaultMessage: '+{count} more',
      values: {
        count: entrySpaces.length - SPACES_DISPLAY_COUNT
      }
    }),
    spacesApiUi: spacesApiUi
  })));
};
exports.SpaceColumnHeader = SpaceColumnHeader;