"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddRuleButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../model");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddRuleButton = props => {
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    "data-test-subj": "roleMappingsAddRuleButton",
    onClick: () => {
      setIsMenuOpen(!isMenuOpen);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRuleButton",
    defaultMessage: "Add"
  }));
  const options = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    id: "addRuleOption",
    key: "rule",
    name: "Add rule",
    icon: "user",
    onClick: () => {
      setIsMenuOpen(false);
      props.onClick(new _model.FieldRule('username', '*'));
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRuleOption",
    defaultMessage: "Add rule"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    id: "addRuleGroupOption",
    key: "ruleGroup",
    name: "Add rule group",
    icon: "list",
    onClick: () => {
      setIsMenuOpen(false);
      props.onClick(new _model.AllRule([new _model.FieldRule('username', '*')]));
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRuleGroupOption",
    defaultMessage: "Add rule group"
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "addRuleContextMenu",
    "data-test-subj": "addRuleContextMenu",
    button: button,
    isOpen: isMenuOpen,
    closePopover: () => setIsMenuOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    title: "Add rule",
    items: options
  }));
};
exports.AddRuleButton = AddRuleButton;