"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersFilterButton = exports.UsernameWithIcon = exports.TypesFilterButton = exports.TimeToolTip = exports.ApiKeysTable = exports.ApiKeyStatus = exports.ApiKeyCreatedCallout = exports.ApiKeyBadge = exports.APIKeysGridPage = void 0;
exports.categorizeApiKeys = categorizeApiKeys;
exports.getApiKeyType = getApiKeyType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _userProfileComponents = require("@kbn/user-profile-components");
var _api_key_flyout = require("./api_key_flyout");
var _api_keys_empty_prompt = require("./api_keys_empty_prompt");
var _invalidate_provider = require("./invalidate_provider");
var _breadcrumb = require("../../../components/breadcrumb");
var _token_field = require("../../../components/token_field");
var _use_capabilities = require("../../../components/use_capabilities");
var _use_current_user = require("../../../components/use_current_user");
var _api_keys_api_client = require("../api_keys_api_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APIKeysGridPage = () => {
  const {
    services
  } = (0, _public2.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const authc = (0, _use_current_user.useAuthentication)();
  const [state, getApiKeys] = (0, _useAsyncFn.default)(() => Promise.all([new _api_keys_api_client.APIKeysAPIClient(services.http).getApiKeys(), authc.getCurrentUser()]), [services.http]);
  const [createdApiKey, setCreatedApiKey] = (0, _react.useState)();
  const [openedApiKey, setOpenedApiKey] = (0, _react.useState)();
  const readOnly = !(0, _use_capabilities.useCapabilities)('api_keys').save;
  (0, _react.useEffect)(() => {
    getApiKeys();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  if (!state.value) {
    if (state.loading) {
      return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.loadingApiKeysDescription",
        defaultMessage: "Loading API keys\u2026"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
      error: state.error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "refresh",
      onClick: () => getApiKeys()
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeys.retryButton",
      defaultMessage: "Try again"
    })));
  }
  const [{
    apiKeys,
    canManageCrossClusterApiKeys,
    canManageApiKeys,
    canManageOwnApiKeys
  }, currentUser] = state.value;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/create"
  }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    text: _i18n.i18n.translate('xpack.security.management.apiKeys.createBreadcrumb', {
      defaultMessage: 'Create'
    }),
    href: "/create"
  }, /*#__PURE__*/_react.default.createElement(_api_key_flyout.ApiKeyFlyout, {
    onSuccess: createApiKeyResponse => {
      history.push({
        pathname: '/'
      });
      setCreatedApiKey(createApiKeyResponse);
      getApiKeys();
    },
    onCancel: () => history.push({
      pathname: '/'
    }),
    canManageCrossClusterApiKeys: canManageCrossClusterApiKeys
  }))), openedApiKey && /*#__PURE__*/_react.default.createElement(_api_key_flyout.ApiKeyFlyout, {
    onSuccess: () => {
      services.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.security.management.apiKeys.updateSuccessMessage', {
          defaultMessage: "Updated API key '{name}'",
          values: {
            name: openedApiKey.name
          }
        }),
        'data-test-subj': 'updateApiKeySuccessToast'
      });
      setOpenedApiKey(undefined);
      getApiKeys();
    },
    onCancel: () => setOpenedApiKey(undefined),
    apiKey: openedApiKey,
    readOnly: readOnly
  }), !apiKeys.length ? /*#__PURE__*/_react.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
    readOnly: readOnly
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public2.reactRouterNavigate)(history, '/create'), {
    fill: true,
    iconType: "plusInCircleFilled",
    "data-test-subj": "apiKeysCreatePromptButton"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.createButton",
    defaultMessage: "Create API key"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.apiKeysTitle",
      defaultMessage: "API keys"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.apiKeysAllDescription",
      defaultMessage: "Allow external services to access the Elastic Stack on behalf of a user."
    }),
    rightSideItems: !readOnly ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public2.reactRouterNavigate)(history, '/create'), {
      fill: true,
      iconType: "plusInCircleFilled",
      "data-test-subj": "apiKeysCreateTableButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.createButton",
      defaultMessage: "Create API key"
    }))] : undefined,
    paddingSize: "none",
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "none"
  }, createdApiKey && !state.loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ApiKeyCreatedCallout, {
    createdApiKey: createdApiKey
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), canManageOwnApiKeys && !canManageApiKeys ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.manageOwnKeysWarning",
      defaultMessage: "You only have permission to manage your own API keys."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : undefined, /*#__PURE__*/_react.default.createElement(_invalidate_provider.InvalidateProvider, {
    isAdmin: canManageApiKeys,
    notifications: services.notifications,
    apiKeysAPIClient: new _api_keys_api_client.APIKeysAPIClient(services.http)
  }, invalidateApiKeyPrompt => /*#__PURE__*/_react.default.createElement(ApiKeysTable, {
    apiKeys: apiKeys,
    onClick: apiKey => setOpenedApiKey(apiKey),
    onDelete: apiKeysToDelete => invalidateApiKeyPrompt(apiKeysToDelete.map(({
      name,
      id
    }) => ({
      name,
      id
    })), getApiKeys),
    currentUser: currentUser,
    createdApiKey: createdApiKey,
    canManageCrossClusterApiKeys: canManageCrossClusterApiKeys,
    canManageApiKeys: canManageApiKeys,
    canManageOwnApiKeys: canManageOwnApiKeys,
    readOnly: readOnly,
    loading: state.loading
  })))));
};
exports.APIKeysGridPage = APIKeysGridPage;
const ApiKeyCreatedCallout = ({
  createdApiKey
}) => {
  const concatenated = `${createdApiKey.id}:${createdApiKey.api_key}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "success",
    iconType: "check",
    title: _i18n.i18n.translate('xpack.security.management.apiKeys.createSuccessMessage', {
      defaultMessage: "Created API key '{name}'",
      values: {
        name: createdApiKey.name
      }
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.successDescription",
    defaultMessage: "Copy this key now. You will not be able to view it again."
  })), /*#__PURE__*/_react.default.createElement(_token_field.SelectableTokenField, {
    options: [{
      key: 'encoded',
      value: createdApiKey.encoded,
      icon: 'empty',
      label: _i18n.i18n.translate('xpack.security.management.apiKeys.encodedLabel', {
        defaultMessage: 'Encoded'
      }),
      description: _i18n.i18n.translate('xpack.security.management.apiKeys.encodedDescription', {
        defaultMessage: 'Format used to make requests to Elasticsearch REST API.'
      })
    }, {
      key: 'beats',
      value: concatenated,
      icon: 'logoBeats',
      label: _i18n.i18n.translate('xpack.security.management.apiKeys.beatsLabel', {
        defaultMessage: 'Beats'
      }),
      description: _i18n.i18n.translate('xpack.security.management.apiKeys.beatsDescription', {
        defaultMessage: 'Format used to configure Beats.'
      })
    }, {
      key: 'logstash',
      value: concatenated,
      icon: 'logoLogstash',
      label: _i18n.i18n.translate('xpack.security.management.apiKeys.logstashLabel', {
        defaultMessage: 'Logstash'
      }),
      description: _i18n.i18n.translate('xpack.security.management.apiKeys.logstashDescription', {
        defaultMessage: 'Format used to configure Logstash.'
      })
    }]
  }));
};
exports.ApiKeyCreatedCallout = ApiKeyCreatedCallout;
const ApiKeysTable = ({
  apiKeys,
  createdApiKey,
  currentUser,
  onClick,
  onDelete,
  canManageApiKeys = false,
  canManageOwnApiKeys = false,
  readOnly = false,
  loading = false
}) => {
  const columns = [];
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const {
    categorizedApiKeys,
    typeFilters,
    usernameFilters,
    expiredFilters
  } = (0, _react.useMemo)(() => categorizeApiKeys(apiKeys), [apiKeys]);
  const deletable = item => canManageApiKeys || canManageOwnApiKeys && item.username === currentUser.username;
  columns.push({
    field: 'name',
    name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.nameColumnName', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (name, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => onClick(item),
        "data-test-subj": `apiKeyRowName-${item.name}`
      }, name);
    }
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.typeColumnName', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    render: type => /*#__PURE__*/_react.default.createElement(ApiKeyBadge, {
      type: type
    })
  });
  if (canManageApiKeys || usernameFilters.length > 1) {
    columns.push({
      field: 'username',
      name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.ownerColumnName', {
        defaultMessage: 'Owner'
      }),
      sortable: true,
      render: username => /*#__PURE__*/_react.default.createElement(UsernameWithIcon, {
        username: username
      })
    });
  }
  columns.push({
    field: 'creation',
    name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.createdColumnName', {
      defaultMessage: 'Created'
    }),
    sortable: true,
    mobileOptions: {
      show: false
    },
    render: (creation, item) => /*#__PURE__*/_react.default.createElement(TimeToolTip, {
      timestamp: creation
    }, item.id === (createdApiKey === null || createdApiKey === void 0 ? void 0 : createdApiKey.id) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.createdBadge",
      defaultMessage: "Just now"
    })) : null)
  }, {
    field: 'expiration',
    name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.statusColumnName', {
      defaultMessage: 'Status'
    }),
    sortable: true,
    render: expiration => /*#__PURE__*/_react.default.createElement(ApiKeyStatus, {
      expiration: expiration
    })
  });
  if (!readOnly) {
    columns.push({
      width: `${24 + 2 * 8}px`,
      actions: [{
        name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.deleteAction', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.security.management.apiKeys.table.deleteDescription', {
          defaultMessage: 'Delete this API key'
        }),
        icon: 'trash',
        type: 'icon',
        color: 'danger',
        onClick: item => onDelete([item]),
        available: deletable,
        'data-test-subj': 'apiKeysTableDeleteAction'
      }]
    });
  }
  const filters = [];
  if (typeFilters.length > 1) {
    filters.push({
      type: 'custom_component',
      component: ({
        query,
        onChange
      }) => /*#__PURE__*/_react.default.createElement(TypesFilterButton, {
        types: typeFilters,
        query: query,
        onChange: onChange
      })
    });
  }
  if (usernameFilters.length > 1) {
    filters.push({
      type: 'custom_component',
      component: ({
        query,
        onChange
      }) => /*#__PURE__*/_react.default.createElement(UsersFilterButton, {
        usernames: usernameFilters,
        query: query,
        onChange: onChange
      })
    });
  }
  if (expiredFilters.length > 1) {
    filters.push({
      type: 'field_value_toggle_group',
      field: 'expired',
      items: [{
        value: false,
        name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.activeFilter', {
          defaultMessage: 'Active'
        })
      }, {
        value: true,
        name: _i18n.i18n.translate('xpack.security.management.apiKeys.table.expiredFilter', {
          defaultMessage: 'Expired'
        })
      }]
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: categorizedApiKeys,
    itemId: "id",
    columns: columns,
    search: categorizedApiKeys.length > 0 ? {
      toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: () => onDelete(selectedItems),
        color: "danger",
        iconType: "trash",
        "data-test-subj": "bulkInvalidateActionButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.invalidateApiKeyButton",
        defaultMessage: "Delete {count, plural, one {API key} other {# API keys}}",
        values: {
          count: selectedItems.length
        }
      })) : undefined,
      box: {
        incremental: true
      },
      filters
    } : undefined,
    sorting: {
      sort: {
        field: 'creation',
        direction: 'desc'
      }
    },
    selection: readOnly ? undefined : {
      selectable: deletable,
      onSelectionChange: setSelectedItems
    },
    pagination: {
      initialPageSize: 10,
      pageSizeOptions: [10, 25, 50]
    },
    loading: loading,
    isSelectable: canManageOwnApiKeys
  });
};
exports.ApiKeysTable = ApiKeysTable;
const TypesFilterButton = ({
  query,
  onChange,
  types
}) => {
  if (!onChange) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, types.includes('rest') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "user",
    iconSide: "left",
    hasActiveFilters: query.hasSimpleFieldClause('type', 'rest'),
    onClick: () => onChange(query.hasSimpleFieldClause('type', 'rest') ? query.removeSimpleFieldClauses('type') : query.removeSimpleFieldClauses('type').addSimpleFieldValue('type', 'rest')),
    withNext: types.includes('cross_cluster') || types.includes('managed')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.restTitle",
    defaultMessage: "Personal"
  })) : null, types.includes('cross_cluster') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "cluster",
    iconSide: "left",
    hasActiveFilters: query.hasSimpleFieldClause('type', 'cross_cluster'),
    onClick: () => onChange(query.hasSimpleFieldClause('type', 'cross_cluster') ? query.removeSimpleFieldClauses('type') : query.removeSimpleFieldClauses('type').addSimpleFieldValue('type', 'cross_cluster')),
    withNext: types.includes('managed')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.crossClusterLabel",
    defaultMessage: "Cross-Cluster"
  })) : null, types.includes('managed') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "gear",
    iconSide: "left",
    hasActiveFilters: query.hasSimpleFieldClause('type', 'managed'),
    onClick: () => onChange(query.hasSimpleFieldClause('type', 'managed') ? query.removeSimpleFieldClauses('type') : query.removeSimpleFieldClauses('type').addSimpleFieldValue('type', 'managed'))
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.managedTitle",
    defaultMessage: "Managed"
  })) : null);
};
exports.TypesFilterButton = TypesFilterButton;
const UsersFilterButton = ({
  query,
  onChange,
  usernames
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  if (!onChange) {
    return null;
  }
  let numActiveFilters = 0;
  const clause = query.getOrFieldClause('username');
  if (clause) {
    if (Array.isArray(clause.value)) {
      numActiveFilters = clause.value.length;
    } else {
      numActiveFilters = 1;
    }
  }
  const usernamesMatchingSearchTerm = searchTerm ? usernames.filter(username => username.includes(searchTerm)) : usernames;
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => setIsOpen(toggle => !toggle),
      isSelected: isOpen,
      numFilters: usernames.length,
      hasActiveFilters: numActiveFilters ? true : false,
      numActiveFilters: numActiveFilters
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.ownerFilter",
      defaultMessage: "Owner"
    })),
    isOpen: isOpen,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    panelClassName: "euiFilterGroup__popoverPanel",
    closePopover: () => setIsOpen(false),
    selectableProps: {
      options: usernamesMatchingSearchTerm.map(username => ({
        uid: username,
        user: {
          username
        },
        enabled: false,
        data: {}
      })),
      onSearchChange: setSearchTerm,
      selectedOptions: usernames.filter(username => query.hasOrFieldClause('username', username)).map(username => ({
        uid: username,
        user: {
          username
        },
        enabled: false,
        data: {}
      })),
      onChange: nextSelectedOptions => {
        const nextQuery = nextSelectedOptions.reduce((acc, option) => acc.addOrFieldValue('username', option.user.username), query.removeOrFieldClauses('username'));
        onChange(nextQuery);
      }
    }
  });
};
exports.UsersFilterButton = UsersFilterButton;
const UsernameWithIcon = ({
  username
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
  user: {
    username
  },
  size: "s"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "apiKeyUsername"
}, username)));
exports.UsernameWithIcon = UsernameWithIcon;
const TimeToolTip = ({
  timestamp,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _momentTimezone.default)(timestamp).format('LLL')
  }, /*#__PURE__*/_react.default.createElement("span", null, children !== null && children !== void 0 ? children : (0, _momentTimezone.default)(timestamp).fromNow()));
};
exports.TimeToolTip = TimeToolTip;
const ApiKeyStatus = ({
  expiration
}) => {
  if (!expiration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "primary",
      "data-test-subj": "apiKeyStatus"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.statusActive",
      defaultMessage: "Active"
    }));
  }
  if (Date.now() > expiration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued",
      "data-test-subj": "apiKeyStatus"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.statusExpired",
      defaultMessage: "Expired"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning",
    "data-test-subj": "apiKeyStatus"
  }, /*#__PURE__*/_react.default.createElement(TimeToolTip, {
    timestamp: expiration
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.statusExpires",
    defaultMessage: "Expires {timeFromNow}",
    values: {
      timeFromNow: (0, _momentTimezone.default)(expiration).fromNow()
    }
  })));
};
exports.ApiKeyStatus = ApiKeyStatus;
const ApiKeyBadge = ({
  type
}) => {
  return type === 'cross_cluster' ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyBadge.crossClusterDescription",
      defaultMessage: "Allows remote clusters to connect to your local cluster."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "cluster"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.crossClusterLabel",
    defaultMessage: "Cross-Cluster"
  }))) : type === 'managed' ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyBadge.managedDescription",
      defaultMessage: "Created and managed by Kibana to correctly run background tasks."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "gear"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.managedTitle",
    defaultMessage: "Managed"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyBadge.restDescription",
      defaultMessage: "Allows external services to access the Elastic Stack on behalf of a user."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "user"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyBadge.restTitle",
    defaultMessage: "Personal"
  })));
};

/**
 * Interface representing a REST API key that is managed by Kibana.
 */

/**
 * Interface representing an API key the way it is presented in the Kibana UI  (with Kibana system
 * API keys given its own dedicated `managed` type).
 */
exports.ApiKeyBadge = ApiKeyBadge;
/**
 * Categorizes API keys by type (with Kibana system API keys given its own dedicated `managed` type)
 * and determines applicable filter values.
 */
function categorizeApiKeys(apiKeys) {
  const categorizedApiKeys = [];
  const typeFilters = new Set();
  const usernameFilters = new Set();
  const expiredFilters = new Set();
  apiKeys.forEach(apiKey => {
    const type = getApiKeyType(apiKey);
    const expired = apiKey.expiration ? Date.now() > apiKey.expiration : false;
    typeFilters.add(type);
    usernameFilters.add(apiKey.username);
    expiredFilters.add(expired);
    categorizedApiKeys.push({
      ...apiKey,
      type,
      expired
    });
  });
  return {
    categorizedApiKeys,
    typeFilters: [...typeFilters],
    usernameFilters: [...usernameFilters],
    expiredFilters: [...expiredFilters]
  };
}
/**
 * Determines API key type the way it is presented in the UI with Kibana system API keys given its own dedicated `managed` type.
 */
function getApiKeyType(apiKey) {
  var _apiKey$metadata;
  return apiKey.type === 'rest' && ((_apiKey$metadata = apiKey.metadata) !== null && _apiKey$metadata !== void 0 && _apiKey$metadata.managed || apiKey.name.indexOf('Alerting: ') === 0) ? 'managed' : apiKey.type;
}