"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APIKeysAPIClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiKeysUrl = '/internal/security/api_key';
class APIKeysAPIClient {
  constructor(http) {
    this.http = http;
  }
  async getApiKeys() {
    return await this.http.get(apiKeysUrl);
  }
  async invalidateApiKeys(apiKeys, isAdmin = false) {
    return await this.http.post(`${apiKeysUrl}/invalidate`, {
      body: JSON.stringify({
        apiKeys,
        isAdmin
      })
    });
  }
  async createApiKey(apiKey) {
    return await this.http.post(apiKeysUrl, {
      body: JSON.stringify(apiKey)
    });
  }
  async updateApiKey(apiKey) {
    return await this.http.put(apiKeysUrl, {
      body: JSON.stringify(apiKey)
    });
  }
}
exports.APIKeysAPIClient = APIKeysAPIClient;