"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeEditor = initializeEditor;
var _brace = _interopRequireDefault(require("brace"));
var _ace = require("@kbn/ace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeEditor({
  el,
  licenseEnabled
}) {
  const editor = _brace.default.acequire('ace/ace').edit(el);
  (0, _ace.installXJsonMode)(editor);
  editor.$blockScrolling = Infinity;
  if (!licenseEnabled) {
    editor.setReadOnly(true);
    editor.container.style.pointerEvents = 'none';
    editor.container.style.opacity = '0.5';
    const textArea = editor.container.querySelector('textarea');
    if (textArea) {
      textArea.setAttribute('tabindex', '-1');
    }
    editor.renderer.setStyle('disabled');
    editor.blur();
  }
  return editor;
}