"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startConnectorSync = void 0;
var _ = require("..");
var _connectors = require("../types/connectors");
var _is_category_entry = require("../utils/is_category_entry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const startConnectorSync = async (client, {
  connectorId,
  jobType,
  targetIndexName
}) => {
  const connectorResult = await client.get({
    id: connectorId,
    index: _.CONNECTORS_INDEX
  });
  const connector = connectorResult._source;
  if (connector) {
    var _filtering$0$active, _filtering$;
    const configuration = Object.entries(connector.configuration).reduce((acc, [key, configEntry]) => {
      if ((0, _is_category_entry.isConfigEntry)(configEntry)) {
        acc[key] = configEntry;
      }
      return acc;
    }, {});
    const {
      filtering,
      index_name: connectorIndexName,
      language,
      pipeline,
      service_type: serviceType
    } = connector;
    const now = new Date().toISOString();
    return await client.index({
      document: {
        cancelation_requested_at: null,
        canceled_at: null,
        completed_at: null,
        connector: {
          configuration,
          filtering: filtering ? (_filtering$0$active = (_filtering$ = filtering[0]) === null || _filtering$ === void 0 ? void 0 : _filtering$.active) !== null && _filtering$0$active !== void 0 ? _filtering$0$active : null : null,
          id: connectorId,
          index_name: targetIndexName || connectorIndexName,
          language,
          pipeline: pipeline !== null && pipeline !== void 0 ? pipeline : null,
          service_type: serviceType
        },
        created_at: now,
        deleted_document_count: 0,
        error: null,
        indexed_document_count: 0,
        indexed_document_volume: 0,
        job_type: jobType || _connectors.SyncJobType.FULL,
        last_seen: null,
        metadata: {},
        started_at: null,
        status: _connectors.SyncStatus.PENDING,
        total_document_count: null,
        trigger_method: _connectors.TriggerMethod.ON_DEMAND,
        worker_hostname: null
      },
      index: _.CURRENT_CONNECTORS_JOB_INDEX
    });
  } else {
    throw new Error('resource_not_found');
  }
};
exports.startConnectorSync = startConnectorSync;