"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearchObjectType = getSavedSearchObjectType;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _search_migrations = require("./search_migrations");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSavedSearchObjectType(getSearchSourceMigrations) {
  return {
    name: 'search',
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'multiple-isolated',
    convertToMultiNamespaceTypeVersion: '8.0.0',
    management: {
      icon: 'discoverApp',
      defaultSearchField: 'title',
      importableAndExportable: true,
      getTitle(obj) {
        return obj.attributes.title;
      },
      getInAppUrl(obj) {
        return {
          path: `/app/discover#/view/${encodeURIComponent(obj.id)}`,
          uiCapabilitiesPath: 'discover.show'
        };
      }
    },
    mappings: {
      dynamic: false,
      properties: {
        title: {
          type: 'text'
        },
        description: {
          type: 'text'
        }
      }
    },
    schemas: {
      '8.8.0': _schema.SCHEMA_SEARCH_V8_8_0,
      '8.12.0': _schema.SCHEMA_SEARCH_V8_12_0
    },
    migrations: () => (0, _search_migrations.getAllMigrations)(getSearchSourceMigrations())
  };
}