"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComponents = void 0;
var _connected = require("../components/connected");
var _edition_modal = require("../components/edition_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getComponents = ({
  capabilities,
  cache,
  overlays,
  theme,
  tagClient,
  notifications
}) => {
  const openCreateModal = (0, _edition_modal.getCreateModalOpener)({
    overlays,
    theme,
    tagClient,
    notifications
  });
  return {
    TagList: (0, _connected.getConnectedTagListComponent)({
      cache
    }),
    TagSelector: (0, _connected.getConnectedTagSelectorComponent)({
      cache,
      capabilities,
      openCreateModal
    }),
    SavedObjectSaveModalTagSelector: (0, _connected.getConnectedSavedObjectModalTagSelectorComponent)({
      cache,
      capabilities,
      openCreateModal
    })
  };
};
exports.getComponents = getComponents;