"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSavedObjectClass = createSavedObjectClass;
var _build_saved_object = require("./helpers/build_saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @name SavedObject
 *
 * NOTE: SavedObject seems to track a reference to an object in ES,
 * and surface methods for CRUD functionality (save and delete). This seems
 * similar to how Backbone Models work.
 *
 * This class seems to interface with ES primarily through the es Angular
 * service and the saved object api.
 */

function createSavedObjectClass(services, decoratorRegistry) {
  /**
   * The SavedObject class is a base class for saved objects loaded from the server and
   * provides additional functionality besides loading/saving/deleting/etc.
   *
   * It is overloaded and configured to provide type-aware functionality.
   * @param {*} config
   */
  class SavedObjectClass {
    constructor(config = {}) {
      // @ts-ignore
      const self = this;
      (0, _build_saved_object.buildSavedObject)(self, config, services, decoratorRegistry.getOrderedDecorators(services));
    }
  }
  return SavedObjectClass;
}