"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractExportDetails = extractExportDetails;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function extractExportDetails(blob) {
  const reader = new FileReader();
  const content = await new Promise((resolve, reject) => {
    reader.addEventListener('loadend', e => {
      resolve(e.target.result);
    });
    reader.addEventListener('error', e => {
      reject(e);
    });
    reader.readAsText(blob, 'utf-8');
  });
  const lines = content.split('\n').filter(l => l.length > 0);
  const maybeDetails = JSON.parse(lines[lines.length - 1]);
  if (isExportDetails(maybeDetails)) {
    return maybeDetails;
  }
}
function isExportDetails(object) {
  return 'exportedCount' in object && 'missingRefCount' in object && 'missingReferences' in object;
}