"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("../../common");
var _services = require("./services");
var _kibana_services = require("../kibana_services");
var _sections = require("./sections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ShareRouterComponent extends _react.Component {
  constructor(...args) {
    super(...args);
    this.registerRouter();
  }
  registerRouter() {
    // Share the router with the app without requiring React or context.
    const {
      history
    } = this.props;
    (0, _services.registerRouter)({
      history
    });
  }
  render() {
    return this.props.children;
  }
}
(0, _defineProperty2.default)(ShareRouterComponent, "propTypes", {
  history: _propTypes.default.shape({
    push: _propTypes.default.func.isRequired,
    createHref: _propTypes.default.func.isRequired
  }).isRequired
});
const ShareRouter = (0, _reactRouterDom.withRouter)(ShareRouterComponent);

// eslint-disable-next-line react/no-multi-comp
class App extends _react.Component {
  componentDidMount() {
    (0, _kibana_services.trackUiMetric)(_services.METRIC_TYPE.LOADED, _common.UIM_APP_LOAD);
  }
  componentWillUnmount() {
    // Set internal flag so we can prevent reacting to route changes internally.
    (0, _services.setUserHasLeftApp)(true);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: this.props.history
    }, /*#__PURE__*/_react.default.createElement(ShareRouter, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      exact: true,
      from: "/",
      to: "/job_list"
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/job_list",
      component: _sections.JobList
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/create",
      component: _sections.JobCreate
    }))));
  }
}
exports.App = App;